/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.context.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.loading.spi.DefaultProjectionHitMapper;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeIndexedTypeContext;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderBuilder;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingMappingContext;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingSessionContext;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class HibernateOrmLoadingContext<E>
implements LoadingContext<EntityReference, E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SessionImplementor sessionImplementor;
    private final ProjectionHitMapper<EntityReference, E> projectionHitMapper;
    private final MutableEntityLoadingOptions loadingOptions;

    private HibernateOrmLoadingContext(SessionImplementor sessionImplementor, ProjectionHitMapper<EntityReference, E> projectionHitMapper, MutableEntityLoadingOptions loadingOptions) {
        this.sessionImplementor = sessionImplementor;
        this.projectionHitMapper = projectionHitMapper;
        this.loadingOptions = loadingOptions;
    }

    public ProjectionHitMapper<EntityReference, E> getProjectionHitMapper() {
        try {
            this.sessionImplementor.checkOpen();
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionIsClosed(e);
        }
        return this.projectionHitMapper;
    }

    public SessionImplementor getSessionImplementor() {
        return this.sessionImplementor;
    }

    public MutableEntityLoadingOptions getLoadingOptions() {
        return this.loadingOptions;
    }

    public static final class Builder<E>
    implements LoadingContextBuilder<EntityReference, E> {
        private final HibernateOrmLoadingSessionContext sessionContext;
        private final EntityLoaderBuilder<E> entityLoaderBuilder;
        private final MutableEntityLoadingOptions loadingOptions;

        public Builder(HibernateOrmLoadingMappingContext mappingContext, HibernateOrmLoadingSessionContext sessionContext, Set<HibernateOrmScopeIndexedTypeContext<? extends E>> indexedTypeContexts) {
            this.sessionContext = sessionContext;
            this.entityLoaderBuilder = new EntityLoaderBuilder(mappingContext, sessionContext, indexedTypeContexts);
            this.loadingOptions = new MutableEntityLoadingOptions(mappingContext);
        }

        public void fetchSize(int fetchSize) {
            this.loadingOptions.setFetchSize(fetchSize);
        }

        public void cacheLookupStrategy(EntityLoadingCacheLookupStrategy strategy) {
            this.entityLoaderBuilder.cacheLookupStrategy(strategy);
        }

        public LoadingContext<EntityReference, E> build() {
            DefaultProjectionHitMapper projectionHitMapper = new DefaultProjectionHitMapper(this.sessionContext.getReferenceHitMapper(), this.entityLoaderBuilder.build(this.loadingOptions));
            return new HibernateOrmLoadingContext(this.sessionContext.getSession(), (ProjectionHitMapper)projectionHitMapper, this.loadingOptions);
        }
    }
}

