/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoadingCacheLookupStrategyImplementor;
import org.hibernate.search.mapper.orm.search.loading.impl.PersistenceContextLookupStrategy;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PersistenceContextThenSecondLevelCacheLookupStrategy<E>
implements EntityLoadingCacheLookupStrategyImplementor<E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EntityLoadingCacheLookupStrategyImplementor<E> persistenceContextLookupStrategy;
    private final EntityPersister persister;
    private final EntityDataAccess cacheAccess;
    private final SessionImplementor session;

    static EntityLoadingCacheLookupStrategyImplementor create(EntityPersister commonEntitySuperTypePersister, SessionImplementor session) {
        EntityLoadingCacheLookupStrategyImplementor<?> persistenceContextLookupStrategy = PersistenceContextLookupStrategy.create(commonEntitySuperTypePersister, session);
        EntityDataAccess cacheAccess = commonEntitySuperTypePersister.getCacheAccessStrategy();
        if (cacheAccess == null) {
            log.skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(commonEntitySuperTypePersister.getEntityName());
            return persistenceContextLookupStrategy;
        }
        return new PersistenceContextThenSecondLevelCacheLookupStrategy(persistenceContextLookupStrategy, commonEntitySuperTypePersister, cacheAccess, session);
    }

    private PersistenceContextThenSecondLevelCacheLookupStrategy(EntityLoadingCacheLookupStrategyImplementor<E> persistenceContextLookupStrategy, EntityPersister persister, EntityDataAccess cacheAccess, SessionImplementor session) {
        this.persistenceContextLookupStrategy = persistenceContextLookupStrategy;
        this.persister = persister;
        this.cacheAccess = cacheAccess;
        this.session = session;
    }

    @Override
    public E lookup(Object entityId) {
        E fromPersistenceContext = this.persistenceContextLookupStrategy.lookup(entityId);
        if (fromPersistenceContext != null) {
            return fromPersistenceContext;
        }
        if (this.cacheAccess == null) {
            return null;
        }
        Serializable serializableEntityId = (Serializable)entityId;
        Object key = this.cacheAccess.generateCacheKey((Object)serializableEntityId, this.persister, this.session.getSessionFactory(), this.session.getTenantIdentifier());
        if (!this.cacheAccess.contains(key)) {
            return null;
        }
        try {
            return (E)this.session.get(this.persister.getEntityName(), serializableEntityId);
        }
        catch (ObjectNotFoundException ignored) {
            return null;
        }
    }
}

