/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.JavaClassPojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractHibernateOrmRawTypeModel<T>
implements PojoRawTypeModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final HibernateOrmBootstrapIntrospector introspector;
    protected final PojoRawTypeIdentifier<T> typeIdentifier;
    protected final XClass xClass;
    private final PojoCaster<T> caster;
    private List<PojoPropertyModel<?>> declaredProperties;

    AbstractHibernateOrmRawTypeModel(HibernateOrmBootstrapIntrospector introspector, PojoRawTypeIdentifier<T> typeIdentifier) {
        this.introspector = introspector;
        this.typeIdentifier = typeIdentifier;
        this.xClass = introspector.toXClass(typeIdentifier.getJavaClass());
        this.caster = new JavaClassPojoCaster(typeIdentifier.getJavaClass());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractHibernateOrmRawTypeModel that = (AbstractHibernateOrmRawTypeModel)o;
        return Objects.equals((Object)this.introspector, (Object)that.introspector) && Objects.equals(this.typeIdentifier, that.typeIdentifier);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.introspector, this.typeIdentifier});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.typeIdentifier + "]";
    }

    public PojoRawTypeIdentifier<T> getTypeIdentifier() {
        return this.typeIdentifier;
    }

    public final String getName() {
        return this.typeIdentifier.toString();
    }

    public boolean isSubTypeOf(MappableTypeModel other) {
        return other instanceof AbstractHibernateOrmRawTypeModel && ((AbstractHibernateOrmRawTypeModel)other).xClass.isAssignableFrom(this.xClass);
    }

    public final PojoRawTypeModel<? super T> getRawType() {
        return this;
    }

    public abstract Stream<? extends AbstractHibernateOrmRawTypeModel<? super T>> getAscendingSuperTypes();

    public abstract Stream<? extends AbstractHibernateOrmRawTypeModel<? super T>> getDescendingSuperTypes();

    public final PojoPropertyModel<?> getProperty(String propertyName) {
        PojoPropertyModel<?> propertyModel = this.getPropertyOrNull(propertyName);
        if (propertyModel == null) {
            throw log.cannotFindReadableProperty(this, propertyName);
        }
        return propertyModel;
    }

    public final Stream<PojoPropertyModel<?>> getDeclaredProperties() {
        if (this.declaredProperties == null) {
            this.declaredProperties = this.getDeclaredPropertyNames().map(this::getPropertyOrNull).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.declaredProperties.stream();
    }

    public final PojoCaster<T> getCaster() {
        return this.caster;
    }

    abstract Stream<String> getDeclaredPropertyNames();

    abstract PojoPropertyModel<?> getPropertyOrNull(String var1);
}

