/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.common.impl;

import java.util.Objects;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

public class EntityReferenceImpl
implements EntityReference {
    private final PojoRawTypeIdentifier<?> typeIdentifier;
    private final String name;
    private final Object id;

    public static EntityReference withDefaultName(Class<?> javaClass, Object id) {
        return EntityReferenceImpl.withName(javaClass, javaClass.getSimpleName(), id);
    }

    public static EntityReference withName(Class<?> javaClass, String entityName, Object id) {
        return new EntityReferenceImpl(PojoRawTypeIdentifier.of(javaClass), entityName, id);
    }

    public EntityReferenceImpl(PojoRawTypeIdentifier<?> typeIdentifier, String name, Object id) {
        this.typeIdentifier = typeIdentifier;
        this.name = name;
        this.id = id;
    }

    @Override
    public Class<?> getType() {
        return this.typeIdentifier.getJavaClass();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EntityReferenceImpl other = (EntityReferenceImpl)obj;
        return this.name.equals(other.name) && Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id);
    }

    public String toString() {
        return this.name + "#" + this.id;
    }
}

