/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.path.spi.StringSetPojoPathFilter;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmPathFilterFactory
implements PojoPathFilterFactory<Set<String>> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PersistentClass persistentClass;

    public HibernateOrmPathFilterFactory(PersistentClass persistentClass) {
        this.persistentClass = persistentClass;
    }

    public PojoPathFilter<Set<String>> create(Set<PojoModelPathValueNode> paths) {
        LinkedHashSet pathsAsStrings = CollectionHelper.newLinkedHashSet((int)paths.size());
        for (PojoModelPathValueNode path : paths) {
            this.addDirtyPathStringRepresentations(pathsAsStrings, path);
        }
        return new StringSetPojoPathFilter((Set)pathsAsStrings);
    }

    private void addDirtyPathStringRepresentations(Set<String> pathsAsStrings, PojoModelPathValueNode path) {
        Optional<Value> valueOptional = this.resolvePath(pathsAsStrings, path, true);
        if (valueOptional.isPresent()) {
            Value value = valueOptional.get();
            throw log.unreportedPathForDirtyChecking((PojoModelPath)path, value);
        }
    }

    private Optional<Value> resolvePath(Set<String> pathsAsStrings, PojoModelPathValueNode path, boolean isWholePath) {
        Property property;
        PojoModelPathPropertyNode propertyNode = path.getParent();
        PojoModelPathValueNode propertyNodeParent = propertyNode.getParent();
        if (propertyNodeParent == null) {
            property = this.resolvePropertyNode(this.persistentClass, propertyNode);
        } else {
            Optional<Value> parentValueOptional = this.resolvePath(pathsAsStrings, propertyNodeParent, false);
            if (!parentValueOptional.isPresent()) {
                return Optional.empty();
            }
            Value parentValue = parentValueOptional.get();
            if (!(parentValue instanceof Component)) {
                throw log.unknownPathForDirtyChecking((PojoModelPath)propertyNode, null);
            }
            property = this.resolvePropertyNode((Component)parentValue, propertyNode);
        }
        return this.resolveValueNode(pathsAsStrings, path, isWholePath, propertyNode, property);
    }

    private Optional<Value> resolveValueNode(Set<String> pathsAsStrings, PojoModelPathValueNode path, boolean isWholePath, PojoModelPathPropertyNode propertyNode, Property property) {
        Value baseValue = property.getValue();
        ContainerExtractorPath extractorPath = path.getExtractorPath();
        if (extractorPath.isDefault()) {
            throw new AssertionFailure("Expected a non-default extractor path as per the " + PojoPathFilterFactory.class.getSimpleName() + " contract");
        }
        Class<?> valueClass = baseValue.getClass();
        if (Component.class.isAssignableFrom(valueClass)) {
            if (extractorPath.isEmpty()) {
                if (isWholePath) {
                    pathsAsStrings.add(propertyNode.toPropertyString());
                    return Optional.empty();
                }
                return Optional.of(baseValue);
            }
        } else {
            if (SimpleValue.class.equals(valueClass)) {
                pathsAsStrings.add(propertyNode.toPropertyString());
                return Optional.empty();
            }
            if (SimpleValue.class.isAssignableFrom(valueClass)) {
                if (isWholePath && HibernateOrmPathFilterFactory.isSingleValuedAssociation(valueClass)) {
                    pathsAsStrings.add(propertyNode.toPropertyString());
                    return Optional.empty();
                }
                return Optional.of(baseValue);
            }
            if (Collection.class.isAssignableFrom(valueClass)) {
                if (extractorPath.isEmpty() && !isWholePath) {
                    throw log.unknownPathForDirtyChecking((PojoModelPath)path, null);
                }
                List extractorNames = extractorPath.getExplicitExtractorNames();
                Iterator<String> extractorNameIterator = extractorNames.iterator();
                return this.resolveExtractorPath(pathsAsStrings, path, isWholePath, propertyNode, baseValue, extractorNameIterator);
            }
        }
        throw log.unknownPathForDirtyChecking((PojoModelPath)path, null);
    }

    private Optional<Value> resolveExtractorPath(Set<String> pathsAsStrings, PojoModelPathValueNode path, boolean isWholePath, PojoModelPathPropertyNode propertyNode, Value baseValue, Iterator<String> extractorNameIterator) {
        Collection collectionValue;
        Value containedValue = baseValue;
        do {
            collectionValue = (Collection)containedValue;
            try {
                String extractorName = extractorNameIterator.hasNext() ? extractorNameIterator.next() : null;
                containedValue = this.resolveExtractor(collectionValue, extractorName);
            }
            catch (SearchException e) {
                throw log.unknownPathForDirtyChecking((PojoModelPath)path, (Exception)((Object)e));
            }
        } while (extractorNameIterator.hasNext() && containedValue instanceof Collection);
        if (!extractorNameIterator.hasNext()) {
            Class<?> containedValueClass = containedValue.getClass();
            if (SimpleValue.class.equals(containedValueClass) || Component.class.isAssignableFrom(containedValueClass) || isWholePath && HibernateOrmPathFilterFactory.isAssociation(containedValueClass)) {
                pathsAsStrings.add(propertyNode.toPropertyString());
                pathsAsStrings.add(collectionValue.getRole());
                return Optional.empty();
            }
            return Optional.of(containedValue);
        }
        throw log.unknownPathForDirtyChecking((PojoModelPath)path, null);
    }

    private Value resolveExtractor(Collection collectionValue, String extractorName) {
        if (collectionValue instanceof Array) {
            if (extractorName == null || "array".equals(extractorName)) {
                return collectionValue.getElement();
            }
        } else if (collectionValue instanceof Map) {
            if ("map-key".equals(extractorName)) {
                return ((Map)collectionValue).getIndex();
            }
            if (extractorName == null || "map-value".equals(extractorName)) {
                return collectionValue.getElement();
            }
        } else if (extractorName == null || "collection".equals(extractorName)) {
            return collectionValue.getElement();
        }
        throw log.invalidContainerExtractorForDirtyChecking(collectionValue.getClass(), extractorName);
    }

    private Property resolvePropertyNode(PersistentClass persistentClass, PojoModelPathPropertyNode propertyNode) {
        try {
            return persistentClass.getProperty(propertyNode.getPropertyName());
        }
        catch (MappingException e) {
            throw log.unknownPathForDirtyChecking((PojoModelPath)propertyNode, (Exception)((Object)e));
        }
    }

    private Property resolvePropertyNode(Component parentValue, PojoModelPathPropertyNode propertyNode) {
        try {
            return parentValue.getProperty(propertyNode.getPropertyName());
        }
        catch (MappingException e) {
            throw log.unknownPathForDirtyChecking((PojoModelPath)propertyNode, (Exception)((Object)e));
        }
    }

    private static boolean isSingleValuedAssociation(Class<? extends Value> valueClass) {
        return ToOne.class.isAssignableFrom(valueClass) || Any.class.isAssignableFrom(valueClass);
    }

    private static boolean isAssociation(Class<? extends Value> valueClass) {
        return OneToMany.class.isAssignableFrom(valueClass) || ToOne.class.isAssignableFrom(valueClass) || Any.class.isAssignableFrom(valueClass);
    }
}

