/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.AbstractCollectionEvent;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.ClearEvent;
import org.hibernate.event.spi.ClearEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.event.impl.EventsHibernateSearchState;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerContextProvider;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContext;
import org.hibernate.search.mapper.orm.event.impl.InitializingHibernateSearchState;
import org.hibernate.search.mapper.orm.event.impl.OptimalEventsHibernateSearchState;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class HibernateSearchEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener,
FlushEventListener,
AutoFlushEventListener,
ClearEventListener {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final boolean dirtyCheckingEnabled;
    private volatile EventsHibernateSearchState state;

    public HibernateSearchEventListener(CompletableFuture<? extends HibernateOrmListenerContextProvider> contextProviderFuture, boolean dirtyCheckingEnabled) {
        this.state = new InitializingHibernateSearchState((CompletableFuture<HibernateOrmListenerContextProvider>)contextProviderFuture.thenApply(this::doInitialize));
        this.dirtyCheckingEnabled = dirtyCheckingEnabled;
    }

    public void onPostDelete(PostDeleteEvent event) {
        HibernateOrmListenerContextProvider contextProvider = this.state.getContextProvider();
        Object entity = event.getEntity();
        HibernateOrmListenerTypeContext typeContext = this.getTypeContext(contextProvider, event.getPersister());
        if (typeContext != null) {
            Object providedId = typeContext.toIndexingPlanProvidedId(event.getId());
            this.getCurrentIndexingPlan(contextProvider, (SessionImplementor)event.getSession()).delete(typeContext.getTypeIdentifier(), providedId, entity);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        HibernateOrmListenerContextProvider contextProvider = this.state.getContextProvider();
        Object entity = event.getEntity();
        HibernateOrmListenerTypeContext typeContext = this.getTypeContext(contextProvider, event.getPersister());
        if (typeContext != null) {
            Object providedId = typeContext.toIndexingPlanProvidedId(event.getId());
            this.getCurrentIndexingPlan(contextProvider, (SessionImplementor)event.getSession()).add(typeContext.getTypeIdentifier(), providedId, entity);
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        HibernateOrmListenerContextProvider contextProvider = this.state.getContextProvider();
        Object entity = event.getEntity();
        HibernateOrmListenerTypeContext typeContext = this.getTypeContext(contextProvider, event.getPersister());
        if (typeContext != null) {
            PojoIndexingPlan<EntityReference> plan = this.getCurrentIndexingPlan(contextProvider, (SessionImplementor)event.getSession());
            Object providedId = typeContext.toIndexingPlanProvidedId(event.getId());
            if (this.dirtyCheckingEnabled) {
                plan.addOrUpdate(typeContext.getTypeIdentifier(), providedId, entity, this.getDirtyPropertyNames(event));
            } else {
                plan.addOrUpdate(typeContext.getTypeIdentifier(), providedId, entity);
            }
        }
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onFlush(FlushEvent event) {
        EventSource session;
        HibernateOrmListenerContextProvider contextProvider = this.state.getContextProvider();
        PojoIndexingPlan<EntityReference> plan = this.getCurrentIndexingPlanIfExisting(contextProvider, (SessionImplementor)(session = event.getSession()));
        if (plan == null) {
            return;
        }
        plan.process();
        if (!session.isTransactionInProgress()) {
            contextProvider.getCurrentAutomaticIndexingSynchronizationStrategy((SessionImplementor)session).executeAndSynchronize(plan);
        }
    }

    public void onAutoFlush(AutoFlushEvent event) throws HibernateException {
        if (!event.isFlushRequired()) {
            return;
        }
        this.getCurrentIndexingPlan(this.state.getContextProvider(), (SessionImplementor)event.getSession()).process();
    }

    public void onClear(ClearEvent event) {
        EventSource session = event.getSession();
        PojoIndexingPlan<EntityReference> plan = this.getCurrentIndexingPlanIfExisting(this.state.getContextProvider(), (SessionImplementor)session);
        if (plan != null) {
            plan.discardNotProcessed();
        }
    }

    private HibernateOrmListenerContextProvider doInitialize(HibernateOrmListenerContextProvider contextProvider) {
        log.debug("Hibernate Search dirty checks " + (this.dirtyCheckingEnabled ? "enabled" : "disabled"));
        this.state = new OptimalEventsHibernateSearchState(contextProvider);
        return contextProvider;
    }

    private PojoIndexingPlan<EntityReference> getCurrentIndexingPlan(HibernateOrmListenerContextProvider contextProvider, SessionImplementor sessionImplementor) {
        return contextProvider.getCurrentIndexingPlan(sessionImplementor, true);
    }

    private PojoIndexingPlan<EntityReference> getCurrentIndexingPlanIfExisting(HibernateOrmListenerContextProvider contextProvider, SessionImplementor sessionImplementor) {
        return contextProvider.getCurrentIndexingPlan(sessionImplementor, false);
    }

    private HibernateOrmListenerTypeContext getTypeContext(HibernateOrmListenerContextProvider contextProvider, EntityPersister entityPersister) {
        String entityName = entityPersister.getEntityName();
        return contextProvider.getTypeContextProvider().getByHibernateOrmEntityName(entityName);
    }

    private void processCollectionEvent(AbstractCollectionEvent event) {
        HibernateOrmListenerContextProvider contextProvider = this.state.getContextProvider();
        Object ownerEntity = event.getAffectedOwnerOrNull();
        if (ownerEntity == null) {
            return;
        }
        HibernateOrmListenerTypeContext typeContext = contextProvider.getTypeContextProvider().getByHibernateOrmEntityName(event.getAffectedOwnerEntityName());
        if (typeContext != null) {
            PojoIndexingPlan<EntityReference> plan = this.getCurrentIndexingPlan(contextProvider, (SessionImplementor)event.getSession());
            Object providedId = typeContext.toIndexingPlanProvidedId(event.getAffectedOwnerIdOrNull());
            if (this.dirtyCheckingEnabled) {
                PersistentCollection persistentCollection = event.getCollection();
                String collectionRole = null;
                if (persistentCollection != null) {
                    collectionRole = persistentCollection.getRole();
                }
                if (collectionRole != null) {
                    plan.addOrUpdate(typeContext.getTypeIdentifier(), providedId, ownerEntity, new String[]{collectionRole});
                } else {
                    plan.addOrUpdate(typeContext.getTypeIdentifier(), providedId, ownerEntity);
                }
            } else {
                plan.addOrUpdate(typeContext.getTypeIdentifier(), providedId, ownerEntity);
            }
        }
    }

    private String[] getDirtyPropertyNames(PostUpdateEvent event) {
        EntityPersister persister = event.getPersister();
        int[] dirtyProperties = event.getDirtyProperties();
        if (dirtyProperties != null && dirtyProperties.length > 0) {
            String[] propertyNames = persister.getPropertyNames();
            int length = dirtyProperties.length;
            String[] dirtyPropertyNames = new String[length];
            for (int i = 0; i < length; ++i) {
                dirtyPropertyNames[i] = propertyNames[dirtyProperties[i]];
            }
            return dirtyPropertyNames;
        }
        return EMPTY_STRING_ARRAY;
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }
}

