/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing;

import org.hibernate.search.util.common.AssertionFailure;

public class MassIndexingFailureContext {
    private final Throwable throwable;
    private final Object failingOperation;

    public static Builder builder() {
        return new Builder();
    }

    MassIndexingFailureContext(Builder builder) {
        this.throwable = builder.throwable == null ? new AssertionFailure("Unknown throwable: missing throwable when reporting the failure. There is probably a bug in Hibernate Search, please report it.") : builder.throwable;
        this.failingOperation = builder.failingOperation == null ? "Unknown operation: missing operation when reporting the failure. There is probably a bug in Hibernate Search, please report it." : builder.failingOperation;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Object getFailingOperation() {
        return this.failingOperation;
    }

    public static class Builder {
        private Throwable throwable;
        private Object failingOperation;

        Builder() {
        }

        public void throwable(Throwable th) {
            this.throwable = th;
        }

        public void failingOperation(Object failingOperation) {
            this.failingOperation = failingOperation;
        }

        public MassIndexingFailureContext build() {
            return new MassIndexingFailureContext(this);
        }
    }
}

