/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Stream;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmClassRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

class HibernateOrmClassPropertyModel<T>
implements PojoPropertyModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmBootstrapIntrospector introspector;
    private final HibernateOrmClassRawTypeModel<?> holderTypeModel;
    private final String name;
    private final List<XProperty> declaredXProperties;
    private final HibernateOrmBasicClassPropertyMetadata ormPropertyMetadata;
    private final Member member;
    private ValueReadHandle<T> handle;
    private PojoGenericTypeModel<T> typeModel;

    HibernateOrmClassPropertyModel(HibernateOrmBootstrapIntrospector introspector, HibernateOrmClassRawTypeModel<?> holderTypeModel, String name, List<XProperty> declaredXProperties, HibernateOrmBasicClassPropertyMetadata ormPropertyMetadata, Member member) {
        this.introspector = introspector;
        this.holderTypeModel = holderTypeModel;
        this.name = name;
        this.declaredXProperties = declaredXProperties;
        this.ormPropertyMetadata = ormPropertyMetadata;
        this.member = member;
    }

    public String getName() {
        return this.name;
    }

    public Stream<Annotation> getAnnotations() {
        return this.declaredXProperties.stream().flatMap(arg_0 -> ((HibernateOrmBootstrapIntrospector)this.introspector).getAnnotations(arg_0));
    }

    public PojoGenericTypeModel<T> getTypeModel() {
        if (this.typeModel == null) {
            try {
                this.typeModel = this.holderTypeModel.getRawTypeDeclaringContext().createGenericTypeModel(this.getGetterGenericReturnType());
            }
            catch (RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.getName(), this.holderTypeModel, e);
            }
        }
        return this.typeModel;
    }

    public ValueReadHandle<T> getHandle() {
        if (this.handle == null) {
            try {
                this.handle = this.introspector.createValueReadHandle(this.member, this.ormPropertyMetadata);
            }
            catch (IllegalAccessException | RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.getName(), this.holderTypeModel, e);
            }
        }
        return this.handle;
    }

    Type getGetterGenericReturnType() {
        if (this.member instanceof Method) {
            return ((Method)this.member).getGenericReturnType();
        }
        if (this.member instanceof Field) {
            return ((Field)this.member).getGenericType();
        }
        throw new AssertionFailure("Unexpected type for a " + Member.class.getName() + ": " + this.member + " has type " + (this.member == null ? null : this.member.getClass()));
    }

    Member getMember() {
        return this.member;
    }
}

