/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.util.Collection;
import java.util.Map;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.SyntheticPojoGenericTypeModel;

public interface HibernateOrmGenericTypeModelFactory<T> {
    public PojoGenericTypeModel<T> create(HibernateOrmBootstrapIntrospector var1);

    public static <T> HibernateOrmGenericTypeModelFactory<T> entityReference(Class<T> javaClass, String entityName) {
        if (Map.class.equals(javaClass)) {
            return HibernateOrmGenericTypeModelFactory.dynamicMap(entityName);
        }
        return HibernateOrmGenericTypeModelFactory.rawType(javaClass);
    }

    public static <T> HibernateOrmGenericTypeModelFactory<T> rawType(Class<T> javaClass) {
        return introspector -> introspector.getGenericTypeModel(javaClass);
    }

    public static HibernateOrmGenericTypeModelFactory<Map> dynamicMap(String name) {
        return introspector -> SyntheticPojoGenericTypeModel.opaqueType((PojoRawTypeModel)introspector.getTypeModel(name));
    }

    public static <T> HibernateOrmGenericTypeModelFactory<T[]> array(HibernateOrmGenericTypeModelFactory<T> elementType) {
        return introspector -> SyntheticPojoGenericTypeModel.array((PojoRawTypeModel)introspector.getTypeModel(Object[].class), elementType.create(introspector));
    }

    public static <C extends Collection> HibernateOrmGenericTypeModelFactory<C> collection(Class<C> collectionType, HibernateOrmGenericTypeModelFactory<?> elementType) {
        return introspector -> SyntheticPojoGenericTypeModel.genericType((PojoRawTypeModel)introspector.getTypeModel(collectionType), elementType.create(introspector), (PojoGenericTypeModel[])new PojoGenericTypeModel[0]);
    }

    public static <M extends Map> HibernateOrmGenericTypeModelFactory<M> map(Class<M> mapType, HibernateOrmGenericTypeModelFactory<?> keyType, HibernateOrmGenericTypeModelFactory<?> valueType) {
        return introspector -> SyntheticPojoGenericTypeModel.genericType((PojoRawTypeModel)introspector.getTypeModel(mapType), keyType.create(introspector), (PojoGenericTypeModel[])new PojoGenericTypeModel[]{valueType.create(introspector)});
    }
}

