/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.orm.model.impl.AbstractHibernateOrmRawTypeModel;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmClassPropertyModel;
import org.hibernate.search.mapper.pojo.model.hcann.spi.PojoCommonsAnnotationsHelper;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

public class HibernateOrmClassRawTypeModel<T>
extends AbstractHibernateOrmRawTypeModel<T> {
    private final HibernateOrmBasicClassTypeMetadata ormTypeMetadata;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext;
    private List<HibernateOrmClassRawTypeModel<? super T>> ascendingSuperTypesCache;
    private List<HibernateOrmClassRawTypeModel<? super T>> descendingSuperTypesCache;
    private final Map<String, HibernateOrmClassPropertyModel<?>> propertyModelCache = new HashMap();
    private Map<String, XProperty> declaredFieldAccessXPropertiesByName;
    private Map<String, XProperty> declaredMethodAccessXPropertiesByName;

    HibernateOrmClassRawTypeModel(HibernateOrmBootstrapIntrospector introspector, PojoRawTypeIdentifier<T> typeIdentifier, HibernateOrmBasicClassTypeMetadata ormTypeMetadata, GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext) {
        super(introspector, typeIdentifier);
        this.ormTypeMetadata = ormTypeMetadata;
        this.rawTypeDeclaringContext = rawTypeDeclaringContext;
    }

    public boolean isAbstract() {
        return this.xClass.isAbstract();
    }

    @Override
    public boolean isSubTypeOf(MappableTypeModel superTypeCandidate) {
        return superTypeCandidate instanceof HibernateOrmClassRawTypeModel && ((HibernateOrmClassRawTypeModel)superTypeCandidate).xClass.isAssignableFrom(this.xClass);
    }

    @Override
    public Stream<HibernateOrmClassRawTypeModel<? super T>> ascendingSuperTypes() {
        if (this.ascendingSuperTypesCache == null) {
            this.ascendingSuperTypesCache = this.introspector.getAscendingSuperTypes(this.xClass).collect(Collectors.toList());
        }
        return this.ascendingSuperTypesCache.stream();
    }

    @Override
    public Stream<HibernateOrmClassRawTypeModel<? super T>> descendingSuperTypes() {
        if (this.descendingSuperTypesCache == null) {
            this.descendingSuperTypesCache = this.introspector.getDescendingSuperTypes(this.xClass).collect(Collectors.toList());
        }
        return this.descendingSuperTypesCache.stream();
    }

    public Stream<Annotation> annotations() {
        return this.introspector.annotations((XAnnotatedElement)this.xClass);
    }

    @Override
    Stream<String> getDeclaredPropertyNames() {
        return Stream.concat(this.getDeclaredFieldAccessXPropertiesByName().keySet().stream(), this.getDeclaredMethodAccessXPropertiesByName().keySet().stream()).distinct();
    }

    @Override
    HibernateOrmClassPropertyModel<?> getPropertyOrNull(String propertyName) {
        return this.propertyModelCache.computeIfAbsent(propertyName, this::createPropertyModel);
    }

    GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> getRawTypeDeclaringContext() {
        return this.rawTypeDeclaringContext;
    }

    private Map<String, XProperty> getDeclaredFieldAccessXPropertiesByName() {
        if (this.declaredFieldAccessXPropertiesByName == null) {
            this.declaredFieldAccessXPropertiesByName = this.introspector.declaredFieldAccessXPropertiesByName(this.xClass);
        }
        return this.declaredFieldAccessXPropertiesByName;
    }

    private Map<String, XProperty> getDeclaredMethodAccessXPropertiesByName() {
        if (this.declaredMethodAccessXPropertiesByName == null) {
            this.declaredMethodAccessXPropertiesByName = this.introspector.declaredMethodAccessXPropertiesByName(this.xClass);
        }
        return this.declaredMethodAccessXPropertiesByName;
    }

    private HibernateOrmClassPropertyModel<?> createPropertyModel(String propertyName) {
        HibernateOrmBasicClassPropertyMetadata ormPropertyMetadata;
        Member member;
        XProperty fieldAccessXProperty;
        ArrayList<XProperty> declaredXProperties = new ArrayList<XProperty>(2);
        XProperty methodAccessXProperty = this.getDeclaredMethodAccessXPropertiesByName().get(propertyName);
        if (methodAccessXProperty != null) {
            declaredXProperties.add(methodAccessXProperty);
        }
        if ((fieldAccessXProperty = this.getDeclaredFieldAccessXPropertiesByName().get(propertyName)) != null) {
            declaredXProperties.add(fieldAccessXProperty);
        }
        if ((member = this.findPropertyMember(propertyName, ormPropertyMetadata = this.findOrmPropertyMetadata(propertyName))) == null) {
            return null;
        }
        return new HibernateOrmClassPropertyModel(this.introspector, this, propertyName, declaredXProperties, ormPropertyMetadata, member);
    }

    private HibernateOrmBasicClassPropertyMetadata findOrmPropertyMetadata(String propertyName) {
        HibernateOrmBasicClassPropertyMetadata propertyMetadata = this.getOrmPropertyMetadataFromThisType(propertyName);
        if (propertyMetadata == null) {
            propertyMetadata = this.getOrmPropertyMetadataFromParentTypes(propertyName);
        }
        return propertyMetadata;
    }

    private Member findPropertyMember(String propertyName, HibernateOrmBasicClassPropertyMetadata ormPropertyMetadata) {
        Member result = this.getPropertyMemberFromThisType(propertyName, ormPropertyMetadata);
        if (result == null) {
            result = this.getPropertyMemberFromParentTypes(propertyName, ormPropertyMetadata);
        }
        return result;
    }

    private HibernateOrmBasicClassPropertyMetadata getOrmPropertyMetadataFromParentTypes(String propertyName) {
        return this.ascendingSuperTypes().skip(1L).map(type -> type.getOrmPropertyMetadataFromThisType(propertyName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private HibernateOrmBasicClassPropertyMetadata getOrmPropertyMetadataFromThisType(String propertyName) {
        if (this.ormTypeMetadata != null) {
            return this.ormTypeMetadata.getClassPropertyMetadataOrNull(propertyName);
        }
        return null;
    }

    private Member getPropertyMemberFromParentTypes(String propertyName, HibernateOrmBasicClassPropertyMetadata ormPropertyMetadata) {
        return this.ascendingSuperTypes().skip(1L).map(type -> type.getPropertyMemberFromThisType(propertyName, ormPropertyMetadata)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Member getPropertyMemberFromThisType(String propertyName, HibernateOrmBasicClassPropertyMetadata propertyMetadataFromHibernateOrmMetamodel) {
        XProperty methodAccessXProperty = this.getDeclaredMethodAccessXPropertiesByName().get(propertyName);
        XProperty fieldAccessXProperty = this.getDeclaredFieldAccessXPropertiesByName().get(propertyName);
        if (propertyMetadataFromHibernateOrmMetamodel != null) {
            return this.getPropertyMemberUsingHibernateOrmMetadataFromThisType(methodAccessXProperty, fieldAccessXProperty, propertyMetadataFromHibernateOrmMetamodel);
        }
        return this.getPropertyMemberUsingReflectionFromThisType(methodAccessXProperty, fieldAccessXProperty);
    }

    private Member getPropertyMemberUsingHibernateOrmMetadataFromThisType(XProperty methodAccessXProperty, XProperty fieldAccessXProperty, HibernateOrmBasicClassPropertyMetadata propertyMetadataFromHibernateOrmMetamodel) {
        Member memberFromHibernateOrmMetamodel = propertyMetadataFromHibernateOrmMetamodel.getMember();
        if (memberFromHibernateOrmMetamodel instanceof Method) {
            return methodAccessXProperty == null ? memberFromHibernateOrmMetamodel : PojoCommonsAnnotationsHelper.extractUnderlyingMember((XProperty)methodAccessXProperty);
        }
        if (memberFromHibernateOrmMetamodel instanceof Field) {
            return fieldAccessXProperty == null ? memberFromHibernateOrmMetamodel : PojoCommonsAnnotationsHelper.extractUnderlyingMember((XProperty)fieldAccessXProperty);
        }
        return null;
    }

    private Member getPropertyMemberUsingReflectionFromThisType(XProperty methodAccessXProperty, XProperty fieldAccessXProperty) {
        if (methodAccessXProperty != null) {
            return PojoCommonsAnnotationsHelper.extractUnderlyingMember((XProperty)methodAccessXProperty);
        }
        if (fieldAccessXProperty != null) {
            return PojoCommonsAnnotationsHelper.extractUnderlyingMember((XProperty)fieldAccessXProperty);
        }
        return null;
    }
}

