/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.orm.model.impl.AbstractHibernateOrmRawTypeModel;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicDynamicMapPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicDynamicMapTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmDynamicMapPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

public class HibernateOrmDynamicMapRawTypeModel
extends AbstractHibernateOrmRawTypeModel<Map> {
    private final HibernateOrmBasicDynamicMapTypeMetadata ormTypeMetadata;
    private final Map<String, HibernateOrmDynamicMapPropertyModel<?>> propertyModelCache = new HashMap();

    HibernateOrmDynamicMapRawTypeModel(HibernateOrmBootstrapIntrospector introspector, PojoRawTypeIdentifier<Map> typeIdentifier, HibernateOrmBasicDynamicMapTypeMetadata ormTypeMetadata) {
        super(introspector, typeIdentifier);
        this.ormTypeMetadata = ormTypeMetadata;
    }

    public final boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isSubTypeOf(MappableTypeModel superTypeCandidate) {
        if (this.equals(superTypeCandidate)) {
            return true;
        }
        AbstractHibernateOrmRawTypeModel<? super Map> superType = this.getSuperType();
        if (superType != null) {
            return superType.isSubTypeOf(superTypeCandidate);
        }
        return false;
    }

    @Override
    public Stream<AbstractHibernateOrmRawTypeModel<? super Map>> ascendingSuperTypes() {
        return Stream.concat(Stream.of(this), this.getSuperType().ascendingSuperTypes());
    }

    @Override
    public Stream<AbstractHibernateOrmRawTypeModel<? super Map>> descendingSuperTypes() {
        return Stream.concat(this.getSuperType().descendingSuperTypes(), Stream.of(this));
    }

    public Stream<Annotation> annotations() {
        return Stream.empty();
    }

    @Override
    HibernateOrmDynamicMapPropertyModel<?> getPropertyOrNull(String propertyName) {
        return this.propertyModelCache.computeIfAbsent(propertyName, this::createPropertyModel);
    }

    @Override
    Stream<String> getDeclaredPropertyNames() {
        return this.ormTypeMetadata.getPropertyNames().stream();
    }

    private AbstractHibernateOrmRawTypeModel<? super Map> getSuperType() {
        HibernateOrmDynamicMapRawTypeModel entitySupertypeOrNull = this.getSuperEntityOrNull();
        if (entitySupertypeOrNull != null) {
            return entitySupertypeOrNull;
        }
        return this.introspector.typeModel(this.typeIdentifier.javaClass());
    }

    private HibernateOrmDynamicMapRawTypeModel getSuperEntityOrNull() {
        String superEntityName = this.ormTypeMetadata.getSuperEntityNameOrNull();
        if (superEntityName != null) {
            return (HibernateOrmDynamicMapRawTypeModel)this.introspector.typeModel(superEntityName);
        }
        return null;
    }

    private HibernateOrmDynamicMapPropertyModel<?> createPropertyModel(String propertyName) {
        HibernateOrmBasicDynamicMapPropertyMetadata ormPropertyMetadata = this.getPropertyMetadata(propertyName);
        if (ormPropertyMetadata == null) {
            return null;
        }
        return new HibernateOrmDynamicMapPropertyModel(this.introspector, this, propertyName, ormPropertyMetadata);
    }

    private HibernateOrmBasicDynamicMapPropertyMetadata getPropertyMetadata(String propertyName) {
        HibernateOrmDynamicMapRawTypeModel entitySupertypeOrNull;
        HibernateOrmBasicDynamicMapPropertyMetadata ormPropertyMetadata = this.ormTypeMetadata.getDynamicMapPropertyMetadataOrNull(propertyName);
        if (ormPropertyMetadata == null && (entitySupertypeOrNull = this.getSuperEntityOrNull()) != null) {
            ormPropertyMetadata = entitySupertypeOrNull.getPropertyMetadata(propertyName);
        }
        return ormPropertyMetadata;
    }
}

