/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmRuntimeIntrospectorTypeContextProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;

public class HibernateOrmRuntimeIntrospector
implements PojoRuntimeIntrospector {
    private final HibernateOrmRuntimeIntrospectorTypeContextProvider typeContextProvider;
    private final SessionImplementor sessionImplementor;

    public HibernateOrmRuntimeIntrospector(HibernateOrmRuntimeIntrospectorTypeContextProvider typeContextProvider, SessionImplementor sessionImplementor) {
        this.typeContextProvider = typeContextProvider;
        this.sessionImplementor = sessionImplementor;
    }

    public <T> PojoRawTypeIdentifier<? extends T> detectEntityType(T entity) {
        if (entity == null) {
            return null;
        }
        String entityName = this.sessionImplementor.bestGuessEntityName(entity);
        if (entityName == null) {
            return null;
        }
        return this.typeContextProvider.typeIdentifierForHibernateOrmEntityName(entityName);
    }

    public Object unproxy(Object value) {
        if (value instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer lazyInitializer = proxy.getHibernateLazyInitializer();
            Object initialized = lazyInitializer.getImplementation((SharedSessionContractImplementor)this.sessionImplementor);
            if (initialized != null) {
                return initialized;
            }
            return this.sessionImplementor.getPersistenceContext().unproxyAndReassociate((Object)proxy);
        }
        return value;
    }
}

