/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoadingCacheLookupStrategyImplementor;
import org.hibernate.search.mapper.orm.search.loading.impl.PersistenceContextLookupStrategy;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PersistenceContextThenSecondLevelCacheLookupStrategy
implements EntityLoadingCacheLookupStrategyImplementor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EntityLoadingCacheLookupStrategyImplementor persistenceContextLookupStrategy;
    private final EntityPersister persister;
    private final EntityDataAccess cacheAccess;
    private final SessionImplementor session;

    static EntityLoadingCacheLookupStrategyImplementor create(EntityPersister commonEntitySuperTypePersister, SessionImplementor session) {
        PersistenceContextLookupStrategy persistenceContextLookupStrategy = PersistenceContextLookupStrategy.create(session);
        EntityDataAccess cacheAccess = commonEntitySuperTypePersister.getCacheAccessStrategy();
        if (cacheAccess == null) {
            log.skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(commonEntitySuperTypePersister.getEntityName());
            return persistenceContextLookupStrategy;
        }
        return new PersistenceContextThenSecondLevelCacheLookupStrategy(persistenceContextLookupStrategy, commonEntitySuperTypePersister, cacheAccess, session);
    }

    private PersistenceContextThenSecondLevelCacheLookupStrategy(EntityLoadingCacheLookupStrategyImplementor persistenceContextLookupStrategy, EntityPersister persister, EntityDataAccess cacheAccess, SessionImplementor session) {
        this.persistenceContextLookupStrategy = persistenceContextLookupStrategy;
        this.persister = persister;
        this.cacheAccess = cacheAccess;
        this.session = session;
    }

    @Override
    public Object lookup(EntityKey entityKey) {
        Object fromPersistenceContext = this.persistenceContextLookupStrategy.lookup(entityKey);
        if (fromPersistenceContext != null) {
            return fromPersistenceContext;
        }
        if (this.cacheAccess == null) {
            return null;
        }
        Object key = this.cacheAccess.generateCacheKey((Object)entityKey.getIdentifier(), this.persister, this.session.getSessionFactory(), this.session.getTenantIdentifier());
        if (!this.cacheAccess.contains(key)) {
            return null;
        }
        try {
            return this.session.get(this.persister.getEntityName(), entityKey.getIdentifier());
        }
        catch (ObjectNotFoundException ignored) {
            return null;
        }
    }
}

