/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.transaction.Synchronization;
import org.hibernate.search.mapper.orm.automaticindexing.session.impl.ConfiguredAutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class InTransactionWorkQueueSynchronization
implements Synchronization {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexingPlan<EntityReference> indexingPlan;
    private final Map<?, ?> indexingPlanPerTransaction;
    private final Object transactionIdentifier;
    private final ConfiguredAutomaticIndexingSynchronizationStrategy synchronizationStrategy;

    InTransactionWorkQueueSynchronization(PojoIndexingPlan<EntityReference> indexingPlan, Map<?, ?> indexingPlanPerTransaction, Object transactionIdentifier, ConfiguredAutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        this.indexingPlan = indexingPlan;
        this.indexingPlanPerTransaction = indexingPlanPerTransaction;
        this.transactionIdentifier = transactionIdentifier;
        this.synchronizationStrategy = synchronizationStrategy;
    }

    public void beforeCompletion() {
        try {
            log.tracef("Processing Transaction's beforeCompletion() phase for %s. Performing work.", this);
            this.synchronizationStrategy.executeAndSynchronize(this.indexingPlan);
        }
        finally {
            this.indexingPlanPerTransaction.remove(this.transactionIdentifier);
        }
    }

    public void afterCompletion(int status) {
    }
}

