/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.persistence.LockModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.query.Query;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingNotifier;
import org.hibernate.search.mapper.orm.massindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class IdentifierConsumerDocumentProducer<E, I>
implements Runnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final String tenantId;
    private final MassIndexingNotifier notifier;
    private final HibernateOrmMassIndexingIndexedTypeContext<E> type;
    private final SingularAttribute<? super E, I> idAttributeOfType;
    private final ProducerConsumerQueue<List<I>> source;
    private final CacheMode cacheMode;
    private final Integer transactionTimeout;
    private final TransactionManager transactionManager;

    IdentifierConsumerDocumentProducer(HibernateOrmMassIndexingMappingContext mappingContext, String tenantId, MassIndexingNotifier notifier, HibernateOrmMassIndexingIndexedTypeContext<E> type, SingularAttribute<? super E, I> idAttributeOfType, ProducerConsumerQueue<List<I>> fromIdentifierListToEntities, CacheMode cacheMode, Integer transactionTimeout) {
        this.mappingContext = mappingContext;
        this.tenantId = tenantId;
        this.notifier = notifier;
        this.source = fromIdentifierListToEntities;
        this.cacheMode = cacheMode;
        this.type = type;
        this.idAttributeOfType = idAttributeOfType;
        this.transactionTimeout = transactionTimeout;
        this.transactionManager = ((JtaPlatform)mappingContext.sessionFactory().getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
        log.trace("created");
    }

    @Override
    public void run() {
        log.trace("started");
        try (SessionImplementor session = (SessionImplementor)this.mappingContext.sessionFactory().withOptions().tenantIdentifier(this.tenantId).openSession();){
            session.setHibernateFlushMode(FlushMode.MANUAL);
            session.setCacheMode(this.cacheMode);
            session.setDefaultReadOnly(true);
            this.loadAllFromQueue(session);
        }
        catch (Exception exception) {
            this.notifier.notifyRunnableFailure(exception, log.massIndexingLoadingAndExtractingEntityData(this.type.jpaEntityName()));
        }
        log.trace("finished");
    }

    private void loadAllFromQueue(SessionImplementor session) throws SystemException, NotSupportedException {
        PojoIndexer indexer = this.mappingContext.createIndexer(session);
        try {
            List<I> idList;
            do {
                if ((idList = this.source.take()) == null) continue;
                log.tracef("received list of ids %s", idList);
                this.loadList(idList, session, indexer);
            } while (idList != null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadList(List<I> listIds, SessionImplementor session, PojoIndexer indexer) throws InterruptedException, NotSupportedException, SystemException {
        try {
            this.beginTransaction((Session)session);
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.type.entityTypeDescriptor().getJavaType());
            Root root = criteriaQuery.from(this.type.entityTypeDescriptor());
            criteriaQuery.select((Selection)root);
            criteriaQuery.where((Expression)root.get(this.idAttributeOfType).in(listIds));
            Query query = session.createQuery(criteriaQuery).setCacheMode(this.cacheMode).setLockMode(LockModeType.NONE).setCacheable(false).setHibernateFlushMode(FlushMode.MANUAL).setFetchSize(listIds.size());
            this.indexAllQueue((Session)session, indexer, query.getResultList());
            session.clear();
        }
        finally {
            this.rollbackTransaction(session);
        }
    }

    private void beginTransaction(Session session) throws SystemException, NotSupportedException {
        if (this.transactionManager != null) {
            if (this.transactionTimeout != null) {
                this.transactionManager.setTransactionTimeout(this.transactionTimeout.intValue());
            }
            this.transactionManager.begin();
        } else {
            session.beginTransaction();
        }
    }

    private void rollbackTransaction(SessionImplementor session) {
        try {
            if (this.transactionManager != null) {
                this.transactionManager.rollback();
            } else {
                session.accessTransaction().rollback();
            }
        }
        catch (Exception e) {
            log.errorRollingBackTransaction(e.getMessage(), e);
        }
    }

    private void indexAllQueue(Session session, PojoIndexer indexer, List<E> entities) throws InterruptedException {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        this.notifier.notifyEntitiesLoaded(entities.size());
        CompletableFuture[] indexingFutures = new CompletableFuture[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            E entity = entities.get(i);
            indexingFutures[i] = this.index(indexer, entity);
        }
        Futures.unwrappedExceptionGet((CompletableFuture)CompletableFuture.allOf(indexingFutures).exceptionally(exception -> null));
        int successfulEntities = 0;
        for (int i = 0; i < entities.size(); ++i) {
            CompletableFuture future = indexingFutures[i];
            if (future.isCompletedExceptionally()) {
                this.notifier.notifyEntityIndexingFailure(this.type, session, entities.get(i), Futures.getThrowableNow((CompletableFuture)future));
                continue;
            }
            ++successfulEntities;
        }
        this.notifier.notifyDocumentsAdded(successfulEntities);
    }

    private CompletableFuture<?> index(PojoIndexer indexer, E entity) throws InterruptedException {
        CompletableFuture future;
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        try {
            future = indexer.add(this.type.typeIdentifier(), null, null, entity, DocumentCommitStrategy.NONE, DocumentRefreshStrategy.NONE);
        }
        catch (RuntimeException e) {
            CompletableFuture future2 = new CompletableFuture();
            future2.completeExceptionally(e);
            return future2;
        }
        this.notifier.notifyDocumentBuilt();
        return future;
    }
}

