/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import org.hibernate.BaseSessionEventListener;
import org.hibernate.Session;
import org.hibernate.SessionEventListener;
import org.hibernate.Transaction;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.backend.common.spi.DocumentReferenceConverter;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.automaticindexing.session.impl.ConfiguredAutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.common.impl.EntityReferenceImpl;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmRuntimeIntrospector;
import org.hibernate.search.mapper.orm.schema.management.SearchSchemaManager;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeSessionContext;
import org.hibernate.search.mapper.orm.scope.impl.SearchScopeImpl;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.context.HibernateOrmSessionContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionMappingContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionIndexedTypeContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContextProvider;
import org.hibernate.search.mapper.orm.session.impl.PostTransactionWorkQueueSynchronization;
import org.hibernate.search.mapper.orm.session.impl.SynchronizationAdapter;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlan;
import org.hibernate.search.mapper.orm.work.SearchWorkspace;
import org.hibernate.search.mapper.orm.work.impl.SearchIndexingPlanImpl;
import org.hibernate.search.mapper.orm.work.impl.SearchIndexingPlanSessionContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchSession;
import org.hibernate.search.mapper.pojo.session.spi.PojoSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.TransientReference;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmSearchSession
extends AbstractPojoSearchSession<EntityReference>
implements SearchSession,
HibernateOrmSessionContext,
HibernateOrmScopeSessionContext,
SearchIndexingPlanSessionContext,
DocumentReferenceConverter<EntityReference>,
EntityReferenceFactory<EntityReference> {
    private static final String SEARCH_SESSION_KEY = HibernateOrmMapping.class.getName() + "#SEARCH_SESSION_KEY";
    private static final String INDEXING_PLAN_PER_TRANSACTION_MAP_KEY = HibernateOrmSearchSession.class.getName() + "#INDEXING_PLAN_PER_TRANSACTION_KEY";
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmSearchSessionMappingContext mappingContext;
    private final HibernateOrmSessionTypeContextProvider typeContextProvider;
    private final SessionImplementor sessionImplementor;
    private final HibernateOrmRuntimeIntrospector runtimeIntrospector;
    private ConfiguredAutomaticIndexingSynchronizationStrategy configuredAutomaticIndexingSynchronizationStrategy;
    private SearchIndexingPlanImpl indexingPlan;

    public static HibernateOrmSearchSession get(HibernateOrmSearchSessionMappingContext context, SessionImplementor sessionImplementor) {
        HibernateOrmSearchSession searchSession;
        HibernateOrmSearchSession.checkOrmSessionIsOpen(sessionImplementor);
        TransientReference reference = (TransientReference)sessionImplementor.getProperties().get(SEARCH_SESSION_KEY);
        HibernateOrmSearchSession hibernateOrmSearchSession = searchSession = reference == null ? null : (HibernateOrmSearchSession)reference.get();
        if (searchSession == null) {
            searchSession = context.createSessionBuilder(sessionImplementor).build();
            reference = new TransientReference((Object)searchSession);
            sessionImplementor.setProperty(SEARCH_SESSION_KEY, (Object)reference);
            sessionImplementor.getEventListenerManager().addListener(new SessionEventListener[]{new SearchSessionClosingListener(sessionImplementor)});
        }
        return searchSession;
    }

    private HibernateOrmSearchSession(Builder builder) {
        super((PojoSearchSessionMappingContext)builder.mappingContext);
        this.mappingContext = builder.mappingContext;
        this.typeContextProvider = builder.typeContextProvider;
        this.sessionImplementor = builder.sessionImplementor;
        this.runtimeIntrospector = builder.buildRuntimeIntrospector();
        this.automaticIndexingSynchronizationStrategy(builder.automaticIndexingSynchronizationStrategy);
    }

    public void close() {
    }

    public String tenantIdentifier() {
        return this.session().getTenantIdentifier();
    }

    @Override
    public PojoIndexer createIndexer() {
        return super.createIndexer();
    }

    @Override
    public <T> SearchQuerySelectStep<?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(Collection<? extends Class<? extends T>> types) {
        return this.search((SearchScopeImpl<T>)this.scope((Collection)types));
    }

    @Override
    public <T> SearchQuerySelectStep<?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(SearchScope<T> scope) {
        return this.search((SearchScopeImpl)scope);
    }

    public <T> SearchQuerySelectStep<?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(SearchScopeImpl<T> scope) {
        return scope.search(this);
    }

    @Override
    public SearchSchemaManager schemaManager(Collection<? extends Class<?>> types) {
        return ((SearchScopeImpl)this.scope(types)).schemaManager();
    }

    @Override
    public SearchWorkspace workspace(Collection<? extends Class<?>> types) {
        return ((SearchScopeImpl)this.scope(types)).workspace(DetachedBackendSessionContext.of((BackendSessionContext)this));
    }

    @Override
    public MassIndexer massIndexer(Collection<? extends Class<?>> types) {
        return ((SearchScopeImpl)this.scope(types)).massIndexer(DetachedBackendSessionContext.of((BackendSessionContext)this));
    }

    public <T> SearchScopeImpl<T> scope(Collection<? extends Class<? extends T>> types) {
        this.checkOrmSessionIsOpen();
        return this.mappingContext.createScope(types);
    }

    @Override
    public <T> SearchScope<T> scope(Class<T> expectedSuperType, Collection<String> entityNames) {
        this.checkOrmSessionIsOpen();
        return this.mappingContext.createScope(expectedSuperType, entityNames);
    }

    @Override
    public EntityManager toEntityManager() {
        return this.sessionImplementor;
    }

    @Override
    public Session toOrmSession() {
        return this.sessionImplementor;
    }

    @Override
    public SearchIndexingPlan indexingPlan() {
        if (this.indexingPlan == null) {
            this.indexingPlan = new SearchIndexingPlanImpl(this.typeContextProvider, this);
        }
        return this.indexingPlan;
    }

    @Override
    public void automaticIndexingSynchronizationStrategy(AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        ConfiguredAutomaticIndexingSynchronizationStrategy.Builder builder = new ConfiguredAutomaticIndexingSynchronizationStrategy.Builder(this.mappingContext.failureHandler());
        synchronizationStrategy.apply(builder);
        this.configuredAutomaticIndexingSynchronizationStrategy = builder.build();
    }

    @Override
    public SessionImplementor session() {
        return this.sessionImplementor;
    }

    @Override
    public BackendSessionContext backendSessionContext() {
        return this;
    }

    @Override
    public DocumentReferenceConverter<EntityReference> referenceHitMapper() {
        return this;
    }

    public EntityReference fromDocumentReference(DocumentReference reference) {
        HibernateOrmSessionIndexedTypeContext<?> typeContext = this.typeContextProvider.indexedForJpaEntityName(reference.typeName());
        if (typeContext == null) {
            throw new AssertionFailure("Document reference " + reference + " refers to an unknown type");
        }
        Object id = typeContext.getIdentifierMapping().fromDocumentIdentifier(reference.id(), (BridgeSessionContext)this);
        return new EntityReferenceImpl(typeContext.typeIdentifier(), typeContext.jpaEntityName(), id);
    }

    @Override
    public EntityReferenceFactory<EntityReference> entityReferenceFactory() {
        return this;
    }

    public EntityReference createEntityReference(String typeName, Object identifier) {
        HibernateOrmSessionIndexedTypeContext<?> typeContext = this.typeContextProvider.indexedForJpaEntityName(typeName);
        if (typeContext == null) {
            throw new AssertionFailure("Type " + typeName + " refers to an unknown type");
        }
        return new EntityReferenceImpl(typeContext.typeIdentifier(), typeContext.jpaEntityName(), identifier);
    }

    @Override
    public PojoRuntimeIntrospector runtimeIntrospector() {
        return this.runtimeIntrospector;
    }

    @Override
    public PojoIndexingPlan<EntityReference> currentIndexingPlan(boolean createIfDoesNotExist) {
        PojoIndexingPlan plan;
        HashMap<Transaction, PojoIndexingPlan<EntityReference>> planPerTransaction;
        this.checkOrmSessionIsOpen();
        Transaction transactionIdentifier = null;
        TransientReference reference = (TransientReference)this.sessionImplementor.getProperties().get(INDEXING_PLAN_PER_TRANSACTION_MAP_KEY);
        HashMap<Transaction, PojoIndexingPlan<EntityReference>> hashMap = planPerTransaction = reference == null ? null : (HashMap<Transaction, PojoIndexingPlan<EntityReference>>)reference.get();
        if (planPerTransaction == null) {
            planPerTransaction = new HashMap<Transaction, PojoIndexingPlan<EntityReference>>();
            reference = new TransientReference(planPerTransaction);
            this.sessionImplementor.setProperty(INDEXING_PLAN_PER_TRANSACTION_MAP_KEY, (Object)reference);
        }
        if (this.sessionImplementor.isTransactionInProgress()) {
            transactionIdentifier = this.sessionImplementor.accessTransaction();
        }
        if ((plan = (PojoIndexingPlan)planPerTransaction.get(transactionIdentifier)) != null) {
            return plan;
        }
        if (!createIfDoesNotExist) {
            return null;
        }
        ConfiguredAutomaticIndexingSynchronizationStrategy currentSynchronizationStrategy = this.configuredAutomaticIndexingSynchronizationStrategy;
        plan = this.createIndexingPlan(currentSynchronizationStrategy.getDocumentCommitStrategy(), currentSynchronizationStrategy.getDocumentRefreshStrategy());
        planPerTransaction.put(transactionIdentifier, plan);
        if (this.sessionImplementor.isTransactionInProgress()) {
            Synchronization txSync = this.createTransactionWorkQueueSynchronization((PojoIndexingPlan<EntityReference>)plan, planPerTransaction, transactionIdentifier, currentSynchronizationStrategy);
            this.registerSynchronization(this.sessionImplementor, txSync);
        }
        return plan;
    }

    @Override
    public ConfiguredAutomaticIndexingSynchronizationStrategy configuredAutomaticIndexingSynchronizationStrategy() {
        return this.configuredAutomaticIndexingSynchronizationStrategy;
    }

    private Synchronization createTransactionWorkQueueSynchronization(PojoIndexingPlan<EntityReference> indexingPlan, Map<Transaction, PojoIndexingPlan<EntityReference>> indexingPlanPerTransaction, Transaction transactionIdentifier, ConfiguredAutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        return new PostTransactionWorkQueueSynchronization(indexingPlan, indexingPlanPerTransaction, transactionIdentifier, synchronizationStrategy);
    }

    private void registerSynchronization(SessionImplementor sessionImplementor, Synchronization synchronization) {
        ActionQueue actionQueue = sessionImplementor.getActionQueue();
        SynchronizationAdapter adapter = new SynchronizationAdapter(synchronization);
        boolean isLocal = this.isLocalTransaction(sessionImplementor);
        if (isLocal) {
            actionQueue.registerProcess((BeforeTransactionCompletionProcess)adapter);
        } else {
            actionQueue.registerProcess((BeforeTransactionCompletionProcess)adapter);
            sessionImplementor.accessTransaction().registerSynchronization((Synchronization)adapter);
        }
        actionQueue.registerProcess((AfterTransactionCompletionProcess)adapter);
    }

    private boolean isLocalTransaction(SessionImplementor sessionImplementor) {
        return !sessionImplementor.getTransactionCoordinator().getTransactionCoordinatorBuilder().isJta();
    }

    private void checkOrmSessionIsOpen() {
        HibernateOrmSearchSession.checkOrmSessionIsOpen(this.sessionImplementor);
    }

    private static void checkOrmSessionIsOpen(SessionImplementor session) {
        try {
            session.checkOpen();
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionIsClosed(e);
        }
    }

    private static class SearchSessionClosingListener
    extends BaseSessionEventListener {
        private final SessionImplementor sessionImplementor;

        private SearchSessionClosingListener(SessionImplementor sessionImplementor) {
            this.sessionImplementor = sessionImplementor;
        }

        public void end() {
            HibernateOrmSearchSession searchSession;
            TransientReference reference = (TransientReference)this.sessionImplementor.getProperties().get(SEARCH_SESSION_KEY);
            HibernateOrmSearchSession hibernateOrmSearchSession = searchSession = reference == null ? null : (HibernateOrmSearchSession)reference.get();
            if (searchSession != null) {
                searchSession.close();
            }
        }
    }

    public static class Builder {
        private final HibernateOrmSearchSessionMappingContext mappingContext;
        private final HibernateOrmSessionTypeContextProvider typeContextProvider;
        private final SessionImplementor sessionImplementor;
        private final AutomaticIndexingSynchronizationStrategy automaticIndexingSynchronizationStrategy;

        public Builder(HibernateOrmSearchSessionMappingContext mappingContext, HibernateOrmSessionTypeContextProvider typeContextProvider, SessionImplementor sessionImplementor, AutomaticIndexingSynchronizationStrategy automaticIndexingSynchronizationStrategy) {
            this.mappingContext = mappingContext;
            this.typeContextProvider = typeContextProvider;
            this.sessionImplementor = sessionImplementor;
            this.automaticIndexingSynchronizationStrategy = automaticIndexingSynchronizationStrategy;
        }

        private HibernateOrmRuntimeIntrospector buildRuntimeIntrospector() {
            return new HibernateOrmRuntimeIntrospector(this.typeContextProvider, this.sessionImplementor);
        }

        public HibernateOrmSearchSession build() {
            return new HibernateOrmSearchSession(this);
        }
    }
}

