/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.work.impl;

import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlan;
import org.hibernate.search.mapper.orm.work.impl.SearchIndexingPlanSessionContext;
import org.hibernate.search.mapper.orm.work.impl.SearchIndexingPlanTypeContextProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;

public final class SearchIndexingPlanImpl
implements SearchIndexingPlan {
    private final SearchIndexingPlanTypeContextProvider typeContextProvider;
    private final SearchIndexingPlanSessionContext sessionContext;

    public SearchIndexingPlanImpl(SearchIndexingPlanTypeContextProvider typeContextProvider, SearchIndexingPlanSessionContext sessionContext) {
        this.typeContextProvider = typeContextProvider;
        this.sessionContext = sessionContext;
    }

    @Override
    public void addOrUpdate(Object entity) {
        this.sessionContext.currentIndexingPlan(true).addOrUpdate(this.getTypeIdentifier(entity), null, null, entity);
    }

    @Override
    public void delete(Object entity) {
        this.sessionContext.currentIndexingPlan(true).delete(this.getTypeIdentifier(entity), null, null, entity);
    }

    @Override
    public void purge(Class<?> entityClass, Object providedId, String providedRoutingKey) {
        this.sessionContext.currentIndexingPlan(true).purge(this.getTypeIdentifier(entityClass), providedId, providedRoutingKey);
    }

    @Override
    public void purge(String entityName, Object providedId, String providedRoutingKey) {
        this.sessionContext.currentIndexingPlan(true).purge(this.getTypeIdentifier(entityName), providedId, providedRoutingKey);
    }

    @Override
    public void process() {
        PojoIndexingPlan<EntityReference> plan = this.sessionContext.currentIndexingPlan(false);
        if (plan == null) {
            return;
        }
        plan.process();
    }

    @Override
    public void execute() {
        PojoIndexingPlan<EntityReference> plan = this.sessionContext.currentIndexingPlan(false);
        if (plan == null) {
            return;
        }
        this.sessionContext.configuredAutomaticIndexingSynchronizationStrategy().executeAndSynchronize(plan);
    }

    private <T> PojoRawTypeIdentifier<? extends T> getTypeIdentifier(T entity) {
        return this.sessionContext.runtimeIntrospector().detectEntityType(entity);
    }

    private <T> PojoRawTypeIdentifier<T> getTypeIdentifier(Class<T> entityType) {
        return this.typeContextProvider.typeIdentifierForJavaClass(entityType);
    }

    private PojoRawTypeIdentifier<?> getTypeIdentifier(String hibernateOrmEntityName) {
        return this.typeContextProvider.typeIdentifierForEntityName(hibernateOrmEntityName);
    }
}

