/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeContainedTypeContext;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoContainedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

class HibernateOrmContainedTypeContext<E> extends AbstractHibernateOrmTypeContext<E>
		implements HibernateOrmScopeContainedTypeContext<E> {

	private HibernateOrmContainedTypeContext(HibernateOrmContainedTypeContext.Builder<E> builder,
			SessionFactoryImplementor sessionFactory) {
		super( sessionFactory, builder.typeIdentifier, builder.jpaEntityName, builder.hibernateOrmEntityName );
	}

	@Override
	public Object toIndexingPlanProvidedId(Object entityId) {
		// The concept of document ID is not relevant for contained types,
		// so we always provide the entity ID to indexing plans
		return entityId;
	}

	static class Builder<E> implements PojoContainedTypeExtendedMappingCollector {
		private final PojoRawTypeIdentifier<E> typeIdentifier;
		private final String jpaEntityName;
		private final String hibernateOrmEntityName;

		Builder(PojoRawTypeIdentifier<E> typeIdentifier, String jpaEntityName, String hibernateOrmEntityName) {
			this.typeIdentifier = typeIdentifier;
			this.jpaEntityName = jpaEntityName;
			this.hibernateOrmEntityName = hibernateOrmEntityName;
		}

		HibernateOrmContainedTypeContext<E> build(SessionFactoryImplementor sessionFactory) {
			return new HibernateOrmContainedTypeContext<>( this, sessionFactory );
		}
	}
}
