/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingIndexedTypeContext;

class MassIndexingIndexedTypeGroup<E> {
    private final HibernateOrmMassIndexingIndexedTypeContext<E> commonSuperType;
    private final Set<HibernateOrmMassIndexingIndexedTypeContext<? extends E>> includedTypes;

    public static List<MassIndexingIndexedTypeGroup<?>> disjoint(Set<? extends HibernateOrmMassIndexingIndexedTypeContext<?>> indexedTypeContexts) {
        ArrayList typeGroups = new ArrayList();
        for (HibernateOrmMassIndexingIndexedTypeContext<?> typeContext : indexedTypeContexts) {
            MassIndexingIndexedTypeGroup<?> typeGroup = MassIndexingIndexedTypeGroup.single(typeContext);
            ListIterator iterator = typeGroups.listIterator();
            while (iterator.hasNext()) {
                MassIndexingIndexedTypeGroup<?> mergeResult = ((MassIndexingIndexedTypeGroup)iterator.next()).mergeOrNull(typeGroup);
                if (mergeResult == null) continue;
                typeGroup = mergeResult;
                iterator.remove();
            }
            typeGroups.add(typeGroup);
        }
        return typeGroups;
    }

    private static <E> MassIndexingIndexedTypeGroup<E> single(HibernateOrmMassIndexingIndexedTypeContext<E> typeContext) {
        return new MassIndexingIndexedTypeGroup<E>(typeContext, Collections.singleton(typeContext));
    }

    private MassIndexingIndexedTypeGroup(HibernateOrmMassIndexingIndexedTypeContext<E> commonSuperType, Set<HibernateOrmMassIndexingIndexedTypeContext<? extends E>> includedTypes) {
        this.commonSuperType = commonSuperType;
        this.includedTypes = includedTypes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[commonSuperType=" + this.commonSuperType + ", includedSubTypes=" + this.includedTypes + "]";
    }

    public HibernateOrmMassIndexingIndexedTypeContext<E> commonSuperType() {
        return this.commonSuperType;
    }

    public SingularAttribute<? super E, ?> idAttribute() {
        EntityTypeDescriptor<E> typeDescriptor = this.commonSuperType.entityTypeDescriptor();
        return typeDescriptor.getId(typeDescriptor.getIdType().getJavaType());
    }

    public Set<Class<? extends E>> includedIndexedTypesOrEmpty() {
        if (this.commonSuperType.entityPersister().getEntityMetamodel().getSubclassEntityNames().size() == this.includedTypes.size()) {
            return Collections.emptySet();
        }
        HashSet<Class<Class>> classes = new HashSet<Class<Class>>(this.includedTypes.size());
        for (HibernateOrmMassIndexingIndexedTypeContext<E> includedType : this.includedTypes) {
            classes.add(includedType.entityTypeDescriptor().getJavaType());
        }
        return classes;
    }

    private MassIndexingIndexedTypeGroup<?> mergeOrNull(MassIndexingIndexedTypeGroup<?> other) {
        EntityPersister otherEntityPersister;
        EntityPersister entityPersister = this.commonSuperType.entityPersister();
        if (HibernateOrmUtils.isSuperTypeOf(entityPersister, otherEntityPersister = other.commonSuperType.entityPersister())) {
            return this.withAdditionalTypes(other.includedTypes);
        }
        if (HibernateOrmUtils.isSuperTypeOf(otherEntityPersister, entityPersister)) {
            return super.withAdditionalTypes(this.includedTypes);
        }
        return null;
    }

    private MassIndexingIndexedTypeGroup<E> withAdditionalTypes(Set<? extends HibernateOrmMassIndexingIndexedTypeContext<? extends E>> otherIncludedSubTypes) {
        HashSet<HibernateOrmMassIndexingIndexedTypeContext<? extends HibernateOrmMassIndexingIndexedTypeContext<? extends E>>> mergedIncludedSubTypes = new HashSet<HibernateOrmMassIndexingIndexedTypeContext<? extends HibernateOrmMassIndexingIndexedTypeContext<? extends E>>>(this.includedTypes);
        mergedIncludedSubTypes.addAll(otherIncludedSubTypes);
        return new MassIndexingIndexedTypeGroup<E>(this.commonSuperType, mergedIncludedSubTypes);
    }
}

