/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmIntegrationBooterImpl;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchSessionFactoryObserver;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextProviderService;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class HibernateSearchIntegrator
implements Integrator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Boolean> ENABLED = ConfigurationProperty.forKey((String)"hibernate.search.enabled").asBoolean().withDefault((Object)true).build();

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        log.version(Version.versionString());
        ConfigurationPropertyChecker propertyChecker = ConfigurationPropertyChecker.create();
        ConfigurationPropertySource propertySource = HibernateOrmIntegrationBooterImpl.getPropertySource((ServiceRegistry)serviceRegistry, propertyChecker);
        if (!((Boolean)ENABLED.get(propertySource)).booleanValue()) {
            log.debug("Hibernate Search is disabled through configuration properties.");
            return;
        }
        BootstrapContext bootstrapContext = ((MetadataImplementor)metadata).getTypeConfiguration().getMetadataBuildingContext().getBootstrapContext();
        HibernateOrmIntegrationBooterImpl booter = new HibernateOrmIntegrationBooterImpl.BuilderImpl(metadata, bootstrapContext).configurationPropertySource(propertySource, propertyChecker).build();
        CompletableFuture<SessionFactoryImplementor> sessionFactoryCreatedFuture = new CompletableFuture<SessionFactoryImplementor>();
        CompletableFuture sessionFactoryClosingFuture = new CompletableFuture();
        CompletableFuture<HibernateSearchContextProviderService> contextFuture = booter.orchestrateBootAndShutdown(sessionFactoryCreatedFuture, sessionFactoryClosingFuture);
        HibernateSearchSessionFactoryObserver observer = new HibernateSearchSessionFactoryObserver(contextFuture, sessionFactoryCreatedFuture, sessionFactoryClosingFuture);
        sessionFactory.addObserver((SessionFactoryObserver)observer);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

