/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.common.impl;

import java.lang.invoke.MethodHandles;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class TransactionHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final TransactionManager transactionManager;
    private final boolean useJta;

    public TransactionHelper(SessionFactoryImplementor sessionFactory) {
        this.transactionManager = ((JtaPlatform)sessionFactory.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
        TransactionCoordinatorBuilder transactionCoordinatorBuilder = (TransactionCoordinatorBuilder)sessionFactory.getServiceRegistry().getService(TransactionCoordinatorBuilder.class);
        this.useJta = TransactionHelper.shouldUseJta(this.transactionManager, transactionCoordinatorBuilder);
    }

    public void begin(SharedSessionContractImplementor session, Integer transactionTimeout) {
        try {
            if (this.useJta) {
                if (transactionTimeout != null) {
                    this.transactionManager.setTransactionTimeout(transactionTimeout.intValue());
                }
                this.transactionManager.begin();
            } else {
                session.accessTransaction().begin();
            }
        }
        catch (NotSupportedException | SystemException e) {
            throw log.transactionHandlingException(e.getMessage(), e);
        }
    }

    public void commit(SharedSessionContractImplementor session) {
        try {
            if (this.useJta) {
                this.transactionManager.commit();
            } else {
                session.accessTransaction().commit();
            }
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
            throw log.transactionHandlingException(e.getMessage(), e);
        }
    }

    public void rollback(SharedSessionContractImplementor session) {
        try {
            if (this.useJta) {
                this.transactionManager.rollback();
            } else {
                session.accessTransaction().rollback();
            }
        }
        catch (Exception e) {
            throw log.transactionHandlingException(e.getMessage(), e);
        }
    }

    private static boolean shouldUseJta(TransactionManager transactionManager, TransactionCoordinatorBuilder transactionCoordinatorBuilder) {
        if (!transactionCoordinatorBuilder.isJta()) {
            log.trace("TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction");
            return false;
        }
        if (transactionManager == null) {
            log.trace("No TransactionManager found, do not start a surrounding JTA transaction");
            return false;
        }
        try {
            if (transactionManager.getStatus() == 6) {
                log.trace("No Transaction in progress, needs to start a JTA transaction");
                return true;
            }
        }
        catch (SystemException e) {
            log.cannotGuessTransactionStatus((Exception)((Object)e));
            return false;
        }
        log.trace("Transaction in progress, no need to start a JTA transaction");
        return false;
    }
}

