/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.databasepolling.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.AdditionalJaxbMappingProducer;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.search.mapper.orm.coordination.databasepolling.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.jandex.IndexView;

public class DatabasePollingAdditionalJaxbMappingProducer
implements AdditionalJaxbMappingProducer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String HSEARCH_TABLE_NAME_PREFIX = "HSEARCH_";
    private static final String OUTBOX_TABLE_NAME = "HSEARCH_OUTBOX_TABLE";
    private static final String OUTBOX_ENTITY_DEFINITION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<hibernate-mapping>\n    <class name=\"" + OutboxEvent.class.getName() + "\" table=\"" + "HSEARCH_OUTBOX_TABLE" + "\">\n        <id name=\"id\" column=\"ID\" type=\"long\">\n            <generator class=\"org.hibernate.id.enhanced.SequenceStyleGenerator\">\n                <param name=\"sequence_name\">" + "HSEARCH_OUTBOX_TABLE" + "_GENERATOR</param>\n                <param name=\"table_name\">" + "HSEARCH_OUTBOX_TABLE" + "_GENERATOR</param>\n                <param name=\"initial_value\">1</param>\n                <param name=\"increment_size\">1</param>\n            </generator>\n        </id>\n        <property name=\"entityName\" type=\"string\" />\n        <property name=\"entityId\" type=\"string\" />\n        <property name=\"entityIdHash\" type=\"integer\" index=\"entityIdHash\" />\n        <property name=\"payload\" type=\"binary\" length=\"8192\" />\n        <property name=\"retries\" type=\"integer\" />\n    </class>\n</hibernate-mapping>\n";

    public Collection<MappingDocument> produceAdditionalMappings(MetadataImplementor metadata, IndexView jandexIndex, MappingBinder mappingBinder, MetadataBuildingContext buildingContext) {
        StandardServiceRegistry serviceRegistry = metadata.getMetadataBuildingOptions().getServiceRegistry();
        ConfigurationService service = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        Object customIndexingStrategy = service.getSettings().get("hibernate.search.coordination.strategy");
        if (!"database-polling".equals(customIndexingStrategy)) {
            return Collections.emptyList();
        }
        log.outboxGeneratedEntityMapping(OUTBOX_ENTITY_DEFINITION);
        Origin origin = new Origin(SourceType.OTHER, "search");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(OUTBOX_ENTITY_DEFINITION.getBytes());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
        Binding binding = mappingBinder.bind((InputStream)bufferedInputStream, origin);
        JaxbHbmHibernateMapping root = (JaxbHbmHibernateMapping)binding.getRoot();
        MappingDocument mappingDocument = new MappingDocument(root, origin, buildingContext);
        return Collections.singletonList(mappingDocument);
    }
}

