/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.databasepolling.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.coordination.databasepolling.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.coordination.databasepolling.impl.OutboxEventFinder;
import org.hibernate.search.mapper.orm.coordination.databasepolling.impl.OutboxEventFinderProvider;
import org.hibernate.search.mapper.orm.coordination.databasepolling.impl.OutboxEventPredicate;

public final class DefaultOutboxEventFinder
implements OutboxEventFinder {
    private final String queryString;
    private final Map<String, Object> params;

    public static String createQueryString(Optional<OutboxEventPredicate> predicate) {
        return "select e from OutboxEvent e" + predicate.map(p -> " where " + p.queryPart("e")).orElse("") + " order by e.id";
    }

    public static Query<OutboxEvent> createQuery(Session session, int maxResults, String queryString, Map<String, Object> params) {
        Query query = session.createQuery(queryString, OutboxEvent.class);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        query.setMaxResults(maxResults);
        query.setLockOptions(new LockOptions(LockMode.PESSIMISTIC_WRITE).setTimeOut(-2));
        return query;
    }

    public DefaultOutboxEventFinder(Optional<OutboxEventPredicate> predicate) {
        this.queryString = DefaultOutboxEventFinder.createQueryString(predicate);
        this.params = predicate.map(OutboxEventPredicate::params).orElse(Collections.emptyMap());
    }

    @Override
    public List<OutboxEvent> findOutboxEvents(Session session, int maxResults) {
        return DefaultOutboxEventFinder.createQuery(session, maxResults, this.queryString, this.params).list();
    }

    public static final class Provider
    implements OutboxEventFinderProvider {
        @Override
        public DefaultOutboxEventFinder create(Optional<OutboxEventPredicate> predicate) {
            return new DefaultOutboxEventFinder(predicate);
        }
    }
}

