/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.databasepolling.impl;

import java.util.Arrays;
import java.util.Objects;
import javax.persistence.Transient;
import org.hibernate.search.mapper.orm.coordination.databasepolling.impl.OutboxEventReference;

public final class OutboxEvent {
    private Long id;
    private String entityName;
    private String entityId;
    private int entityIdHash;
    private byte[] payload;
    private int retries = 0;
    @Transient
    private Object originalEntityId;

    public OutboxEvent() {
    }

    public OutboxEvent(String entityName, String entityId, int entityIdHash, byte[] payload, Object originalEntityId) {
        this.entityName = entityName;
        this.entityId = entityId;
        this.entityIdHash = entityIdHash;
        this.payload = payload;
        this.originalEntityId = originalEntityId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public int getEntityIdHash() {
        return this.entityIdHash;
    }

    public void setEntityIdHash(int entityIdHash) {
        this.entityIdHash = entityIdHash;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public Object getOriginalEntityId() {
        return this.originalEntityId;
    }

    public void setOriginalEntityId(Object originalEntityId) {
        this.originalEntityId = originalEntityId;
    }

    OutboxEventReference getReference() {
        return new OutboxEventReference(this.getEntityName(), this.getEntityId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutboxEvent event = (OutboxEvent)o;
        return Objects.equals(this.entityName, event.entityName) && Objects.equals(this.entityId, event.entityId) && Arrays.equals(this.payload, event.payload);
    }

    public int hashCode() {
        int result = Objects.hash(this.entityName, this.entityId);
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }

    public String toString() {
        return "OutboxEvent{id=" + this.id + ", entityName='" + this.entityName + '\'' + ", entityId='" + this.entityId + '\'' + ", entityIdHash='" + this.entityIdHash + '\'' + ", retries=" + this.retries + ", originalEntityId=" + this.originalEntityId + '}';
    }
}

