/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.databasepolling.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.OptimisticLockException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.search.engine.backend.orchestration.spi.SingletonTask;
import org.hibernate.search.engine.reporting.EntityIndexingFailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingMappingContext;
import org.hibernate.search.mapper.orm.common.impl.TransactionHelper;
import org.hibernate.search.mapper.orm.coordination.databasepolling.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.coordination.databasepolling.impl.OutboxEventFinder;
import org.hibernate.search.mapper.orm.coordination.databasepolling.impl.OutboxEventProcessingPlan;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class OutboxEventBackgroundProcessor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final int MAX_RETRIES = 3;
    private final String name;
    private final AutomaticIndexingMappingContext mapping;
    private final OutboxEventFinder finder;
    private final int pollingInterval;
    private final int batchSize;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.STOPPED);
    private final FailureHandler failureHandler;
    private final SingletonTask processingTask;

    public OutboxEventBackgroundProcessor(String name, AutomaticIndexingMappingContext mapping, ScheduledExecutorService executor, OutboxEventFinder finder, int pollingInterval, int batchSize) {
        this.name = name;
        this.mapping = mapping;
        this.finder = finder;
        this.pollingInterval = pollingInterval;
        this.batchSize = batchSize;
        this.failureHandler = mapping.failureHandler();
        this.processingTask = new SingletonTask(name, (SingletonTask.Worker)new HibernateOrmOutboxWorker(mapping.sessionFactory()), (SingletonTask.Scheduler)new HibernateOrmOutboxScheduler(executor), this.failureHandler);
    }

    public void start() {
        log.startingOutboxEventProcessor(this.name);
        this.status.set(Status.STARTED);
        this.processingTask.ensureScheduled();
    }

    public CompletableFuture<?> preStop() {
        this.status.set(Status.STOPPED);
        return this.processingTask.completion();
    }

    public void stop() {
        log.stoppingOutboxEventProcessor(this.name);
        this.processingTask.stop();
    }

    private static void updateOrDeleteEvents(FailureHandler failureHandler, Session session, OutboxEventProcessingPlan processingPlan) {
        ArrayList<OutboxEvent> eventToDelete = new ArrayList<OutboxEvent>();
        for (OutboxEvent event : processingPlan.getEvents()) {
            eventToDelete.add(event);
        }
        for (OutboxEvent failedEvent : processingPlan.getFailedEvents()) {
            int attempts = failedEvent.getRetries() + 1;
            if (attempts >= 3) {
                EntityIndexingFailureContext.Builder builder = EntityIndexingFailureContext.builder();
                SearchException exception = log.maxRetryExhausted(3);
                builder.throwable((Throwable)exception);
                builder.failingOperation((Object)"Processing an outbox event.");
                builder.entityReference((Object)processingPlan.entityReference(failedEvent.getEntityName(), failedEvent.getEntityId(), (Throwable)exception));
                failureHandler.handle(builder.build());
                continue;
            }
            eventToDelete.remove(failedEvent);
            failedEvent.setRetries(attempts);
            log.automaticIndexingRetry(failedEvent.getId(), failedEvent.getEntityName(), failedEvent.getEntityId(), attempts);
        }
        for (OutboxEvent event : eventToDelete) {
            session.delete((Object)event);
        }
        session.flush();
        session.clear();
    }

    private class HibernateOrmOutboxScheduler
    implements SingletonTask.Scheduler {
        private final ScheduledExecutorService delegate;

        private HibernateOrmOutboxScheduler(ScheduledExecutorService delegate) {
            this.delegate = delegate;
        }

        public Future<?> schedule(Runnable runnable) {
            return this.delegate.schedule(runnable, (long)OutboxEventBackgroundProcessor.this.pollingInterval, TimeUnit.MILLISECONDS);
        }
    }

    private class HibernateOrmOutboxWorker
    implements SingletonTask.Worker {
        private final TransactionHelper transactionHelper;

        public HibernateOrmOutboxWorker(SessionFactoryImplementor sessionFactory) {
            this.transactionHelper = new TransactionHelper(sessionFactory);
        }

        public CompletableFuture<?> work() {
            if (OutboxEventBackgroundProcessor.this.mapping.sessionFactory().isClosed()) {
                log.sessionFactoryIsClosedOnOutboxProcessing();
                return CompletableFuture.completedFuture(null);
            }
            try (SessionImplementor session = (SessionImplementor)OutboxEventBackgroundProcessor.this.mapping.sessionFactory().openSession();){
                List<OutboxEvent> events;
                block15: {
                    this.transactionHelper.begin((SharedSessionContractImplementor)session, null);
                    try {
                        try {
                            events = OutboxEventBackgroundProcessor.this.finder.findOutboxEvents((Session)session, OutboxEventBackgroundProcessor.this.batchSize);
                        }
                        catch (OptimisticLockException lockException) {
                            log.outboxEventProcessorUnableToLock(OutboxEventBackgroundProcessor.this.name, lockException);
                            events = Collections.emptyList();
                        }
                        if (!events.isEmpty()) break block15;
                        this.transactionHelper.commit((SharedSessionContractImplementor)session);
                        CompletableFuture<Object> lockException = CompletableFuture.completedFuture(null);
                        return lockException;
                    }
                    catch (Exception e) {
                        log.tracef(e, e.getMessage(), new Object[0]);
                        try {
                            this.transactionHelper.rollback((SharedSessionContractImplementor)session);
                        }
                        catch (RuntimeException e2) {
                            e.addSuppressed(e2);
                        }
                        throw e;
                    }
                }
                this.ensureScheduled();
                log.tracef("Processing %d outbox events for '%s': '%s'", events.size(), OutboxEventBackgroundProcessor.this.name, events);
                OutboxEventProcessingPlan eventProcessing = new OutboxEventProcessingPlan(OutboxEventBackgroundProcessor.this.mapping, (Session)session, events);
                eventProcessing.processEvents();
                OutboxEventBackgroundProcessor.updateOrDeleteEvents(OutboxEventBackgroundProcessor.this.failureHandler, (Session)session, eventProcessing);
                this.transactionHelper.commit((SharedSessionContractImplementor)session);
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                return completableFuture;
            }
        }

        public void complete() {
            this.ensureScheduled();
        }

        private void ensureScheduled() {
            if (OutboxEventBackgroundProcessor.this.status.get() == Status.STARTED) {
                OutboxEventBackgroundProcessor.this.processingTask.ensureScheduled();
            }
        }
    }

    private static enum Status {
        STOPPED,
        STARTED;

    }
}

