/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.databasepolling.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.Session;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.orm.coordination.databasepolling.impl.OutboxEvent;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventPayload;
import org.hibernate.search.util.common.data.impl.Murmur3HashFunction;
import org.hibernate.search.util.common.data.impl.RangeCompatibleHashFunction;
import org.hibernate.search.util.common.serialization.spi.SerializationUtils;

public class OutboxEventSendingPlan
implements AutomaticIndexingQueueEventSendingPlan {
    public static final RangeCompatibleHashFunction HASH_FUNCTION = Murmur3HashFunction.INSTANCE;
    private final Session session;
    private final List<OutboxEvent> events = new ArrayList<OutboxEvent>();

    public OutboxEventSendingPlan(Session session) {
        this.session = session;
    }

    @Override
    public void append(String entityName, Object identifier, String serializedId, PojoIndexingQueueEventPayload payload) {
        this.events.add(new OutboxEvent(entityName, serializedId, HASH_FUNCTION.hash((CharSequence)serializedId), SerializationUtils.serialize((Object)payload), identifier));
    }

    @Override
    public void discard() {
        this.events.clear();
    }

    @Override
    public <R> CompletableFuture<MultiEntityOperationExecutionReport<R>> sendAndReport(EntityReferenceFactory<R> entityReferenceFactory) {
        if (this.session.isOpen()) {
            return this.sendAndReportOnSession(this.session, entityReferenceFactory);
        }
        try (Session temporarySession = this.session.sessionWithOptions().connection().autoClose(false).connectionHandlingMode(PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_RELEASE_AFTER_TRANSACTION).openSession();){
            CompletableFuture<MultiEntityOperationExecutionReport<R>> completableFuture = this.sendAndReportOnSession(temporarySession, entityReferenceFactory);
            return completableFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> CompletableFuture<MultiEntityOperationExecutionReport<R>> sendAndReportOnSession(Session currentSession, EntityReferenceFactory<R> entityReferenceFactory) {
        try {
            MultiEntityOperationExecutionReport.Builder builder = MultiEntityOperationExecutionReport.builder();
            for (OutboxEvent event : this.events) {
                try {
                    currentSession.persist((Object)event);
                }
                catch (RuntimeException e) {
                    builder.throwable((Throwable)e);
                    builder.failingEntityReference(entityReferenceFactory, event.getEntityName(), event.getOriginalEntityId());
                }
            }
            currentSession.flush();
            CompletableFuture<MultiEntityOperationExecutionReport> completableFuture = CompletableFuture.completedFuture(builder.build());
            return completableFuture;
        }
        finally {
            this.events.clear();
        }
    }
}

