/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Set;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.Query;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.massindexing.impl.ConditionalExpression;

public abstract class ConditionalExpressionQueryFactory<E, I>
implements TypeQueryFactory<E, I> {
    private static final String TYPES_PARAM_NAME = "HIBERNATE_SEARCH_INCLUDED_TYPES_FILTER";
    protected final String uniquePropertyName;

    public ConditionalExpressionQueryFactory(String uniquePropertyName) {
        this.uniquePropertyName = uniquePropertyName;
    }

    @Override
    public Query<Long> createQueryForCount(SharedSessionContractImplementor session, EntityPersister persister, Set<? extends Class<? extends E>> includedTypesFilter, ConditionalExpression conditionalExpression) {
        return this.createQueryWithConditionalExpression(session, "select count(e) from " + persister.getEntityName() + " e", Long.class, "e", includedTypesFilter, conditionalExpression);
    }

    @Override
    public Query<I> createQueryForIdentifierListing(SharedSessionContractImplementor session, EntityPersister persister, Set<? extends Class<? extends E>> includedTypesFilter, ConditionalExpression conditionalExpression) {
        return this.createQueryWithConditionalExpression(session, "select e. " + this.uniquePropertyName + " from " + persister.getEntityName() + " e", persister.getIdentifierType().getReturnedClass(), "e", includedTypesFilter, conditionalExpression);
    }

    private <T> Query<T> createQueryWithConditionalExpression(SharedSessionContractImplementor session, String hql, Class<T> returnedType, String entityAlias, Set<? extends Class<? extends E>> includedTypesFilter, ConditionalExpression conditionalExpression) {
        if (includedTypesFilter.isEmpty()) {
            return this.createQueryWithConditionalExpression(session, hql, returnedType, conditionalExpression);
        }
        hql = hql + " where type(" + entityAlias + ") in (:" + TYPES_PARAM_NAME + ") and " + conditionalExpression.hql();
        QueryImplementor query = session.createQuery(hql, returnedType);
        query.setParameterList(TYPES_PARAM_NAME, includedTypesFilter);
        conditionalExpression.applyParams((Query<?>)query);
        return query;
    }

    private <T> Query<T> createQueryWithConditionalExpression(SharedSessionContractImplementor session, String hql, Class<T> returnedType, ConditionalExpression conditionalExpression) {
        hql = hql + " where " + conditionalExpression.hql();
        QueryImplementor query = session.createQuery(hql, returnedType);
        conditionalExpression.applyParams((Query<?>)query);
        return query;
    }
}

