/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.List;
import javax.persistence.LockModeType;
import org.hibernate.FlushMode;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.common.impl.TransactionHelper;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassLoadingOptions;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmQueryLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntityLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntitySink;

public final class HibernateOrmMassEntityLoader<E, I>
implements PojoMassEntityLoader<I> {
    private static final String ID_PARAMETER_NAME = "ids";
    private final HibernateOrmQueryLoader<E, ?> typeQueryLoader;
    private final HibernateOrmMassLoadingOptions options;
    private final PojoMassEntitySink<E> sink;
    private final SessionImplementor session;
    private final TransactionHelper transactionHelper;

    public HibernateOrmMassEntityLoader(HibernateOrmQueryLoader<E, ?> typeGroupLoader, HibernateOrmMassLoadingOptions options, PojoMassEntitySink<E> sink, SessionImplementor session) {
        this.typeQueryLoader = typeGroupLoader;
        this.options = options;
        this.sink = sink;
        this.session = session;
        this.transactionHelper = new TransactionHelper(session.getSessionFactory());
    }

    public void close() {
        this.session.close();
    }

    public void load(List<I> identifiers) throws InterruptedException {
        this.transactionHelper.begin((SharedSessionContractImplementor)this.session, null);
        try {
            Query query = this.typeQueryLoader.createLoadingQuery(this.session, ID_PARAMETER_NAME).setParameter(ID_PARAMETER_NAME, identifiers).setCacheMode(this.options.cacheMode()).setLockMode(LockModeType.NONE).setCacheable(false).setHibernateFlushMode(FlushMode.MANUAL).setFetchSize(identifiers.size());
            this.sink.accept(query.getResultList());
            this.session.clear();
        }
        catch (Exception e) {
            try {
                this.transactionHelper.rollback((SharedSessionContractImplementor)this.session);
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
        this.transactionHelper.commit((SharedSessionContractImplementor)this.session);
    }
}

