/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Set;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.Query;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.search.mapper.orm.loading.impl.ConditionalExpressionQueryFactory;

class HqlTypeQueryFactory<E, I>
extends ConditionalExpressionQueryFactory<E, I> {
    private final EntityPersister entityPersister;

    HqlTypeQueryFactory(EntityPersister entityPersister, String uniquePropertyName) {
        super(uniquePropertyName);
        this.entityPersister = entityPersister;
    }

    @Override
    public Query<Long> createQueryForCount(SharedSessionContractImplementor session, Set<? extends Class<? extends E>> includedTypesFilter) {
        return this.createQueryWithTypesFilter(session, "select count(e) from " + this.entityPersister.getEntityName() + " e", Long.class, "e", includedTypesFilter);
    }

    @Override
    public Query<I> createQueryForIdentifierListing(SharedSessionContractImplementor session, Set<? extends Class<? extends E>> includedTypesFilter) {
        return this.createQueryWithTypesFilter(session, "select e. " + this.uniquePropertyName + " from " + this.entityPersister.getEntityName() + " e", this.entityPersister.getIdentifierType().getReturnedClass(), "e", includedTypesFilter);
    }

    @Override
    public Query<E> createQueryForLoadByUniqueProperty(SessionImplementor session, String parameterName) {
        return session.createQuery("select e from " + this.entityPersister.getEntityName() + " e where " + this.uniquePropertyName + " in (:" + parameterName + ")", this.entityPersister.getMappedClass());
    }

    private <T> Query<T> createQueryWithTypesFilter(SharedSessionContractImplementor session, String hql, Class<T> returnedType, String entityAlias, Set<? extends Class<? extends E>> includedTypesFilter) {
        if (!includedTypesFilter.isEmpty()) {
            hql = hql + " where type(" + entityAlias + ") in (:types)";
        }
        QueryImplementor query = session.createQuery(hql, returnedType);
        if (!includedTypesFilter.isEmpty()) {
            query.setParameterList("types", includedTypesFilter);
        }
        return query;
    }
}

