/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingFinalizationContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingPartialBuildState;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.mapper.orm.coordination.common.spi.CooordinationStrategy;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmTypeContextContainer;
import org.hibernate.search.mapper.orm.session.impl.ConfiguredAutomaticIndexingStrategy;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.util.common.impl.Closer;

public class HibernateOrmMappingPartialBuildState
implements MappingPartialBuildState {
    private final PojoMappingDelegate mappingDelegate;
    private final HibernateOrmTypeContextContainer.Builder typeContextContainerBuilder;
    private final BeanHolder<? extends CooordinationStrategy> coordinationStrategyHolder;
    private final ConfiguredAutomaticIndexingStrategy configuredAutomaticIndexingStrategy;

    HibernateOrmMappingPartialBuildState(PojoMappingDelegate mappingDelegate, HibernateOrmTypeContextContainer.Builder typeContextContainerBuilder, BeanHolder<? extends CooordinationStrategy> coordinationStrategyHolder, ConfiguredAutomaticIndexingStrategy configuredAutomaticIndexingStrategy) {
        this.mappingDelegate = mappingDelegate;
        this.typeContextContainerBuilder = typeContextContainerBuilder;
        this.coordinationStrategyHolder = coordinationStrategyHolder;
        this.configuredAutomaticIndexingStrategy = configuredAutomaticIndexingStrategy;
    }

    public MappingImplementor<HibernateOrmMapping> bindToSessionFactory(MappingFinalizationContext context, SessionFactoryImplementor sessionFactoryImplementor) {
        return HibernateOrmMapping.create(this.mappingDelegate, this.typeContextContainerBuilder.build(sessionFactoryImplementor), this.coordinationStrategyHolder, this.configuredAutomaticIndexingStrategy, sessionFactoryImplementor, context.configurationPropertySource());
    }

    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(ConfiguredAutomaticIndexingStrategy::stop, (Object)this.configuredAutomaticIndexingStrategy);
            closer.push(CooordinationStrategy::stop, this.coordinationStrategyHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.coordinationStrategyHolder);
            closer.push(PojoMappingDelegate::close, (Object)this.mappingDelegate);
        }
    }
}

