/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Collection;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.loading.impl.ConditionalExpressionQueryFactory;

class CriteriaTypeQueryFactory<E, I>
extends ConditionalExpressionQueryFactory<E, I> {
    private final EntityDomainType<E> type;
    private final SingularAttribute<? super E, I> uniqueProperty;

    public static <E> CriteriaTypeQueryFactory<E, ?> create(EntityDomainType<E> type, String uniquePropertyName) {
        return new CriteriaTypeQueryFactory(type, uniquePropertyName, type.getSingularAttribute(uniquePropertyName));
    }

    private CriteriaTypeQueryFactory(EntityDomainType<E> type, String uniquePropertyName, SingularAttribute<? super E, I> uniqueProperty) {
        super(uniquePropertyName);
        this.type = type;
        this.uniqueProperty = uniqueProperty;
    }

    @Override
    public Query<Long> createQueryForCount(SharedSessionContractImplementor session, Set<? extends Class<? extends E>> includedTypesFilter) {
        CriteriaBuilder criteriaBuilder = session.getFactory().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(this.type);
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)root));
        if (!includedTypesFilter.isEmpty()) {
            criteriaQuery.where((Expression)root.type().in(includedTypesFilter));
        }
        return session.createQuery(criteriaQuery);
    }

    @Override
    public Query<I> createQueryForIdentifierListing(SharedSessionContractImplementor session, Set<? extends Class<? extends E>> includedTypesFilter) {
        CriteriaBuilder criteriaBuilder = session.getFactory().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.uniqueProperty.getJavaType());
        Root root = criteriaQuery.from(this.type);
        Path idPath = root.get(this.uniqueProperty);
        criteriaQuery.select((Selection)idPath);
        if (!includedTypesFilter.isEmpty()) {
            criteriaQuery.where((Expression)root.type().in(includedTypesFilter));
        }
        return session.createQuery(criteriaQuery);
    }

    @Override
    public Query<E> createQueryForLoadByUniqueProperty(SessionImplementor session, String parameterName) {
        CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
        ParameterExpression idsParameter = criteriaBuilder.parameter(Collection.class, parameterName);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.type.getJavaType());
        Root root = criteriaQuery.from(this.type);
        Path uniquePropertyInRoot = root.get(this.uniqueProperty);
        criteriaQuery.where((Expression)uniquePropertyInRoot.in(new Expression[]{idsParameter}));
        return session.createQuery(criteriaQuery);
    }

    @Override
    public MultiIdentifierLoadAccess<E> createMultiIdentifierLoadAccess(SessionImplementor session) {
        return session.byMultipleIds(this.type.getJavaType());
    }

    @Override
    public boolean uniquePropertyIsTheEntityId() {
        return this.uniqueProperty.isId();
    }
}

