/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.query.spi;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.persistence.QueryTimeoutException;
import org.hibernate.ScrollableResults;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.search.engine.search.query.SearchScroll;
import org.hibernate.search.engine.search.query.SearchScrollResult;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.type.Type;

public class HibernateOrmSearchScrollableResultsAdapter<H>
implements ScrollableResults,
ScrollableResultsImplementor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SearchScroll<H> scroll;
    private final int maxResults;
    private final ScrollHitExtractor<? super H> hitExtractor;
    private SearchScrollResult<H> currentChunk;
    private H currentHit;
    private int currentIndexInScroll;
    private int currentIndexInCurrentChunk;
    private boolean afterLast;
    private boolean closed;

    public HibernateOrmSearchScrollableResultsAdapter(SearchScroll<H> scroll, int maxResults, ScrollHitExtractor<? super H> hitExtractor) {
        this.scroll = scroll;
        this.maxResults = maxResults;
        this.hitExtractor = hitExtractor;
        this.currentChunk = null;
        this.currentHit = null;
        this.currentIndexInScroll = -1;
        this.currentIndexInCurrentChunk = -1;
        this.afterLast = false;
        this.closed = false;
    }

    public boolean next() {
        this.checkNotClosed();
        return this.scroll(1);
    }

    public boolean previous() {
        this.checkNotClosed();
        throw log.cannotScrollBackwards();
    }

    public boolean scroll(int positions) {
        this.checkNotClosed();
        if (positions < 0) {
            throw log.cannotScrollBackwards();
        }
        if (this.afterLast) {
            return false;
        }
        if (positions == 0) {
            return this.currentIndexInScroll >= 0;
        }
        this.currentIndexInScroll += positions;
        this.currentIndexInCurrentChunk += positions;
        if (this.currentIndexInScroll >= this.maxResults) {
            this.afterLast();
            return false;
        }
        if (this.currentChunk == null) {
            this.currentChunk = this.nextChunk();
        }
        int currentChunkSize = this.currentChunk.hits().size();
        while (this.currentIndexInCurrentChunk >= currentChunkSize && this.currentChunk.hasHits()) {
            this.currentIndexInCurrentChunk -= currentChunkSize;
            this.currentChunk = this.nextChunk();
            currentChunkSize = this.currentChunk.hits().size();
        }
        if (this.currentIndexInCurrentChunk >= this.currentChunk.hits().size()) {
            this.afterLast();
            return false;
        }
        this.currentHit = this.currentChunk.hits().get(this.currentIndexInCurrentChunk);
        if (this.currentIndexInCurrentChunk == currentChunkSize - 1) {
            this.currentChunk = this.nextChunk();
            this.currentIndexInCurrentChunk = -1;
        }
        return true;
    }

    public boolean last() {
        this.checkNotClosed();
        if (this.afterLast) {
            throw log.cannotScrollBackwards();
        }
        while (!this.isLast() && !this.afterLast) {
            this.next();
        }
        return this.isLast();
    }

    public boolean first() {
        this.checkNotClosed();
        if (this.currentIndexInScroll == 0) {
            return true;
        }
        if (this.currentIndexInScroll != -1) {
            throw log.cannotScrollBackwards();
        }
        return this.scroll(1);
    }

    public void beforeFirst() {
        this.checkNotClosed();
        if (this.currentIndexInScroll != -1) {
            throw log.cannotScrollBackwards();
        }
    }

    public void afterLast() {
        this.checkNotClosed();
        this.currentChunk = null;
        this.currentHit = null;
        this.currentIndexInScroll = Integer.MAX_VALUE;
        this.currentIndexInCurrentChunk = -1;
        this.afterLast = true;
    }

    public boolean isFirst() {
        return !this.afterLast && this.currentIndexInScroll == 0;
    }

    public boolean isLast() {
        return !this.afterLast && (this.currentIndexInScroll == this.maxResults - 1 || this.currentChunk != null && !this.currentChunk.hasHits());
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.scroll.close();
        }
        catch (RuntimeException e) {
            log.unableToCloseSearcherInScrollableResult(e);
        }
    }

    public int getRowNumber() {
        if (this.afterLast) {
            return -1;
        }
        return this.currentIndexInScroll;
    }

    public boolean setRowNumber(int rowNumber) {
        this.checkNotClosed();
        if (rowNumber < 0) {
            throw log.cannotSetScrollPositionRelativeToEnd();
        }
        return this.scroll(rowNumber - this.currentIndexInScroll);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Object[] get() {
        this.checkNotClosed();
        if (this.currentIndexInScroll < 0 || this.afterLast) {
            return null;
        }
        return this.hitExtractor.toArray(this.currentHit);
    }

    public Object get(int i) {
        this.checkNotClosed();
        if (this.currentIndexInScroll < 0 || this.afterLast) {
            return null;
        }
        return this.hitExtractor.toElement(this.currentHit, i);
    }

    public Type getType(int i) {
        throw this.columnTypesNotSupported();
    }

    public Integer getInteger(int col) {
        throw this.columnTypesNotSupported();
    }

    public Long getLong(int col) {
        throw this.columnTypesNotSupported();
    }

    public Float getFloat(int col) {
        throw this.columnTypesNotSupported();
    }

    public Boolean getBoolean(int col) {
        throw this.columnTypesNotSupported();
    }

    public Double getDouble(int col) {
        throw this.columnTypesNotSupported();
    }

    public Short getShort(int col) {
        throw this.columnTypesNotSupported();
    }

    public Byte getByte(int col) {
        throw this.columnTypesNotSupported();
    }

    public Character getCharacter(int col) {
        throw this.columnTypesNotSupported();
    }

    public byte[] getBinary(int col) {
        throw this.columnTypesNotSupported();
    }

    public String getText(int col) {
        throw this.columnTypesNotSupported();
    }

    public Blob getBlob(int col) {
        throw this.columnTypesNotSupported();
    }

    public Clob getClob(int col) {
        throw this.columnTypesNotSupported();
    }

    public String getString(int col) {
        throw this.columnTypesNotSupported();
    }

    public BigDecimal getBigDecimal(int col) {
        throw this.columnTypesNotSupported();
    }

    public BigInteger getBigInteger(int col) {
        throw this.columnTypesNotSupported();
    }

    public Date getDate(int col) {
        throw this.columnTypesNotSupported();
    }

    public Locale getLocale(int col) {
        throw this.columnTypesNotSupported();
    }

    public Calendar getCalendar(int col) {
        throw this.columnTypesNotSupported();
    }

    public TimeZone getTimeZone(int col) {
        throw this.columnTypesNotSupported();
    }

    public int getNumberOfTypes() {
        throw this.columnTypesNotSupported();
    }

    private SearchScrollResult<H> nextChunk() {
        try {
            return this.scroll.next();
        }
        catch (SearchTimeoutException e) {
            throw new QueryTimeoutException((Throwable)e);
        }
    }

    private UnsupportedOperationException columnTypesNotSupported() {
        return new UnsupportedOperationException("column types not supported in Hibernate Search queries");
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw log.cannotUseClosedScrollableResults();
        }
    }

    private static final class SingleObjectScrollHitExtractor<H>
    implements ScrollHitExtractor<H> {
        private static final SingleObjectScrollHitExtractor<Object> INSTANCE = new SingleObjectScrollHitExtractor();

        private SingleObjectScrollHitExtractor() {
        }

        @Override
        public Object[] toArray(H hit) {
            return new Object[]{hit};
        }

        @Override
        public Object toElement(H hit, int index) {
            if (index > 0) {
                throw new IndexOutOfBoundsException();
            }
            return hit;
        }
    }

    public static interface ScrollHitExtractor<H> {
        public Object[] toArray(H var1);

        public Object toElement(H var1, int var2);

        public static <H> ScrollHitExtractor<H> singleObject() {
            return SingleObjectScrollHitExtractor.INSTANCE;
        }
    }
}

