/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingEventSendingSessionContext;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateSearchOrmMappingProducer;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationConfigurationContext;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategy;
import org.hibernate.search.mapper.orm.session.impl.ConfiguredAutomaticIndexingStrategy;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public final class CoordinationConfigurationContextImpl
implements CoordinationConfigurationContext,
AutoCloseable {
    private static final ConfigurationProperty<BeanReference<? extends CoordinationStrategy>> COORDINATION_STRATEGY = ConfigurationProperty.forKey((String)"hibernate.search.coordination.strategy").asBeanReference(CoordinationStrategy.class).withDefault(HibernateOrmMapperSettings.Defaults.COORDINATION_STRATEGY).build();
    private final BeanHolder<? extends CoordinationStrategy> strategyHolder;
    private final List<HibernateSearchOrmMappingProducer> mappingProducers = new ArrayList<HibernateSearchOrmMappingProducer>();
    private Function<AutomaticIndexingEventSendingSessionContext, AutomaticIndexingQueueEventSendingPlan> senderFactory;
    private boolean enlistsInTransaction = false;

    public static CoordinationConfigurationContextImpl configure(ConfigurationPropertySource propertySource, BeanResolver beanResolver) {
        BeanHolder strategyHolder = (BeanHolder)COORDINATION_STRATEGY.getAndTransform(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));
        CoordinationConfigurationContextImpl context = new CoordinationConfigurationContextImpl((BeanHolder<? extends CoordinationStrategy>)strategyHolder);
        try {
            ((CoordinationStrategy)strategyHolder.get()).configure(context);
            return context;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(CoordinationConfigurationContextImpl::close, (Object)context);
            throw e;
        }
    }

    public CoordinationConfigurationContextImpl(BeanHolder<? extends CoordinationStrategy> strategyHolder) {
        this.strategyHolder = strategyHolder;
    }

    @Override
    public void close() {
        this.strategyHolder.close();
    }

    @Override
    public void reindexInSession() {
        this.senderFactory = null;
        this.enlistsInTransaction = false;
    }

    @Override
    public void sendIndexingEventsTo(Function<AutomaticIndexingEventSendingSessionContext, AutomaticIndexingQueueEventSendingPlan> senderFactory, boolean enlistsInTransaction) {
        this.senderFactory = senderFactory;
        this.enlistsInTransaction = enlistsInTransaction;
    }

    @Override
    public void mappingProducer(HibernateSearchOrmMappingProducer producer) {
        this.mappingProducers.add(producer);
    }

    public BeanHolder<? extends CoordinationStrategy> strategyHolder() {
        return this.strategyHolder;
    }

    public ConfiguredAutomaticIndexingStrategy createAutomaticIndexingStrategy() {
        return new ConfiguredAutomaticIndexingStrategy(this.senderFactory, this.enlistsInTransaction);
    }

    public List<HibernateSearchOrmMappingProducer> mappingProducers() {
        return this.mappingProducers;
    }
}

