/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicDynamicMapPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicDynamicMapTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmDynamicMapPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.AbstractPojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;

public class HibernateOrmDynamicMapRawTypeModel
extends AbstractPojoRawTypeModel<Map, HibernateOrmBootstrapIntrospector> {
    private final HibernateOrmBasicDynamicMapTypeMetadata ormTypeMetadata;

    HibernateOrmDynamicMapRawTypeModel(HibernateOrmBootstrapIntrospector introspector, PojoRawTypeIdentifier<Map> typeIdentifier, HibernateOrmBasicDynamicMapTypeMetadata ormTypeMetadata) {
        super((PojoBootstrapIntrospector)introspector, typeIdentifier);
        this.ormTypeMetadata = ormTypeMetadata;
    }

    public final boolean isAbstract() {
        return false;
    }

    public boolean isSubTypeOf(MappableTypeModel superTypeCandidate) {
        if (this.equals(superTypeCandidate)) {
            return true;
        }
        PojoRawTypeModel<? super Map> superType = this.getSuperType();
        if (superType != null) {
            return superType.isSubTypeOf(superTypeCandidate);
        }
        return false;
    }

    public Stream<PojoRawTypeModel<? super Map>> ascendingSuperTypes() {
        return Stream.concat(Stream.of(this), this.getSuperType().ascendingSuperTypes());
    }

    public Stream<PojoRawTypeModel<? super Map>> descendingSuperTypes() {
        return Stream.concat(this.getSuperType().descendingSuperTypes(), Stream.of(this));
    }

    public Optional<? extends PojoTypeModel<?>> typeArgument(Class<?> rawSuperType, int typeParameterIndex) {
        return Optional.empty();
    }

    public Optional<? extends PojoTypeModel<?>> arrayElementType() {
        return Optional.empty();
    }

    public Stream<Annotation> annotations() {
        return Stream.empty();
    }

    protected List<PojoConstructorModel<Map>> createDeclaredConstructors() {
        return Collections.emptyList();
    }

    public PojoTypeModel<? extends Map> cast(PojoTypeModel<?> other) {
        if (other.rawType().isSubTypeOf((MappableTypeModel)this)) {
            return other;
        }
        return this;
    }

    protected Stream<String> declaredPropertyNames() {
        return this.ormTypeMetadata.getPropertyNames().stream();
    }

    private PojoRawTypeModel<? super Map> getSuperType() {
        HibernateOrmDynamicMapRawTypeModel entitySupertypeOrNull = this.getSuperEntityOrNull();
        if (entitySupertypeOrNull != null) {
            return entitySupertypeOrNull;
        }
        return ((HibernateOrmBootstrapIntrospector)this.introspector).typeModel(this.typeIdentifier.javaClass());
    }

    private HibernateOrmDynamicMapRawTypeModel getSuperEntityOrNull() {
        String superEntityName = this.ormTypeMetadata.getSuperEntityNameOrNull();
        if (superEntityName != null) {
            return (HibernateOrmDynamicMapRawTypeModel)((HibernateOrmBootstrapIntrospector)this.introspector).typeModel(superEntityName);
        }
        return null;
    }

    protected HibernateOrmDynamicMapPropertyModel<?> createPropertyModel(String propertyName) {
        HibernateOrmBasicDynamicMapPropertyMetadata ormPropertyMetadata = this.getPropertyMetadata(propertyName);
        if (ormPropertyMetadata == null) {
            return null;
        }
        return new HibernateOrmDynamicMapPropertyModel((HibernateOrmBootstrapIntrospector)this.introspector, this, propertyName, ormPropertyMetadata);
    }

    private HibernateOrmBasicDynamicMapPropertyMetadata getPropertyMetadata(String propertyName) {
        HibernateOrmDynamicMapRawTypeModel entitySupertypeOrNull;
        HibernateOrmBasicDynamicMapPropertyMetadata ormPropertyMetadata = this.ormTypeMetadata.getDynamicMapPropertyMetadataOrNull(propertyName);
        if (ormPropertyMetadata == null && (entitySupertypeOrNull = this.getSuperEntityOrNull()) != null) {
            ormPropertyMetadata = entitySupertypeOrNull.getPropertyMetadata(propertyName);
        }
        return ormPropertyMetadata;
    }
}

