/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.ScrollMode;
import org.hibernate.SessionFactory;
import org.hibernate.mapping.Value;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=800000, max=809999), @ValidIdRange(min=34, max=34), @ValidIdRange(min=36, max=36), @ValidIdRange(min=39, max=39), @ValidIdRange(min=62, max=62), @ValidIdRange(min=116, max=116), @ValidIdRange(min=183, max=183), @ValidIdRange(min=211, max=212), @ValidIdRange(min=276, max=276), @ValidIdRange(min=348, max=349)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_LEGACY_ENGINE = 0;
    public static final int ID_OFFSET = 800000;

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=34, value="Hibernate Search version %1$s")
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=36, value="Unable to guess the transaction status: not starting a JTA transaction.")
    public void cannotGuessTransactionStatus(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=39, value="Unable to properly close scroll in ScrollableResults.")
    public void unableToCloseSearcherInScrollableResult(@Cause Exception var1);

    @Message(id=276, value="No transaction active. Consider increasing the connection time-out.")
    public SearchException transactionNotActiveWhileProducingIdsForBatchIndexing();

    @Message(id=800001, value="Hibernate Search was not initialized.")
    public SearchException hibernateSearchNotInitialized();

    @Message(id=800003, value="Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidAutomaticIndexingStrategyName(String var1, List<String> var2);

    @Message(id=800007, value="Unable to resolve path '%1$s' to a persisted attribute in Hibernate ORM metadata. If this path points to a transient attribute, use @IndexingDependency(derivedFrom = ...) to specify which persisted attributes it is derived from. See the reference documentation for more information.")
    public SearchException unknownPathForDirtyChecking(@FormatWith(value=PojoModelPathFormatter.class) PojoModelPath var1, @Cause Exception var2);

    @Message(id=800008, value="Path '%1$s' points to attribute '%2$s' that will never be reported as dirty by Hibernate ORM. Check that you didn't declare an invalid indexing dependency.")
    public SearchException unreportedPathForDirtyChecking(@FormatWith(value=PojoModelPathFormatter.class) PojoModelPath var1, Value var2);

    @Message(id=800009, value="Unable to apply container value extractor with name '%2$s' to Hibernate ORM metadata node of type '%1$s'.")
    public SearchException invalidContainerExtractorForDirtyChecking(Class<?> var1, String var2);

    @Message(id=800011, value="Unable to create a SearchSession for sessions created using a different session factory. Expected: '%1$s'. In use: '%2$s'.")
    public SearchException usingDifferentSessionFactories(SessionFactory var1, SessionFactory var2);

    @Message(id=800012, value="Unable to retrieve property type model for '%1$s' on '%2$s': %3$s")
    public SearchException errorRetrievingPropertyTypeModel(String var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2, String var3, @Cause Exception var4);

    @Message(id=800016, value="Unable to access Hibernate ORM session: %1$s")
    public SearchException hibernateSessionAccessError(String var1, @Cause IllegalStateException var2);

    @Message(id=800017, value="Underlying Hibernate ORM Session is closed.")
    public SearchException hibernateSessionIsClosed(@Cause IllegalStateException var1);

    @Message(id=800018, value="Invalid automatic indexing synchronization strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidAutomaticIndexingSynchronizationStrategyName(String var1, List<String> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=800019, value="The entity loader for '%1$s' is ignoring the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.")
    public void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(String var1, EntityLoadingCacheLookupStrategy var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=800020, value="The entity loader for '%1$s' is ignoring the second-level cache even though it was instructed to use it, because caching is not enabled for this entity type.")
    public void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(String var1);

    @Message(id=800021, value="Unable to access Hibernate ORM session factory: %1$s")
    public SearchException hibernateSessionFactoryAccessError(String var1, @Cause IllegalStateException var2);

    @Message(id=800022, value="Indexing failure: %1$s.\nThe following entities may not have been updated correctly in the index: %2$s.")
    public SearchException indexingFailure(String var1, List<?> var2, @Cause Throwable var3);

    @Message(id=800023, value="Unable to process entities for automatic indexing before transaction completion: %1$s")
    public SearchException synchronizationBeforeTransactionFailure(String var1, @Cause Throwable var2);

    @Message(id=800024, value="Unable to index documents for automatic indexing after transaction completion: %1$s")
    public SearchException synchronizationAfterTransactionFailure(String var1, @Cause Throwable var2);

    @Message(id=800025, value="Unable to handle transaction: %1$s")
    public SearchException transactionHandlingException(String var1, @Cause Throwable var2);

    @Message(id=800027, value="Unknown type: '%1$s'. Available named types: %2$s. For entity types, the correct type name is the entity name. For component types (embeddeds, ...) in dynamic-map entities, the correct type name is name of the owner entity followed by a dot ('.') followed by the dot-separated path to the component, e.g. 'MyEntity.myEmbedded' or 'MyEntity.myEmbedded.myNestedEmbedded'.")
    public SearchException unknownNamedType(String var1, Collection<String> var2);

    @Message(id=800028, value="No matching entity type for name '%1$s'. This is not the name of a Hibernate ORM entity type. Valid names for Hibernate ORM entity types are: %2$s")
    public SearchException unknownEntityNameForEntityType(String var1, Collection<String> var2);

    @Message(id=800029, value="Invalid type for '%1$s': the entity type must extend '%2$s', but entity type '%3$s' does not.")
    public SearchException invalidEntitySuperType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=800032, value="Invalid schema management strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidSchemaManagementStrategyName(String var1, List<String> var2);

    @Message(id=800033, value="No matching indexed entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not indexed in Hibernate Search. Valid classes for indexed entity types are: %2$s")
    public SearchException unknownClassForIndexedEntityType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=CommaSeparatedClassesFormatter.class) Collection<Class<?>> var2);

    @Message(id=800034, value="No matching indexed entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not indexed in Hibernate Search. Valid names for indexed entity types are: %2$s")
    public SearchException unknownEntityNameForIndexedEntityType(String var1, Collection<String> var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=800035, value="Unable to shut down Hibernate Search: %1$s")
    public void shutdownFailed(String var1, @Cause Throwable var2);

    @Message(id=800036, value="Cannot use scroll() with scroll mode '%1$s' with Hibernate Search queries: only ScrollMode.FORWARDS_ONLY is supported.")
    public SearchException canOnlyUseScrollWithScrollModeForwardsOnly(ScrollMode var1);

    @Message(id=800037, value="Cannot scroll backwards with Hibernate Search scrolls: they are forwards-only. Ensure you always increment the scroll position, and never decrement it.")
    public SearchException cannotScrollBackwards();

    @Message(id=800038, value="Cannot set the scroll position relative to the end with Hibernate Search scrolls. Ensure you always pass a positive number to setRowNumber().")
    public SearchException cannotSetScrollPositionRelativeToEnd();

    @Message(id=800039, value="Cannot use this ScrollableResults instance: it is closed.")
    public SearchException cannotUseClosedScrollableResults();

    @Message(id=800040, value="Multiple instances of entity type '%1$s' have their property '%2$s' set to '%3$s'. '%2$s' is the document ID and must be assigned unique values.")
    public SearchException foundMultipleEntitiesForDocumentId(String var1, String var2, Object var3);

    @Message(id=800041, value="No such bean in bean container '%1$s'.")
    public BeanNotFoundException beanNotFoundInBeanContainer(BeanContainer var1);

    @Message(id=800042, value="Cannot customize the synchronization strategy:  the selected automatic indexing strategy always processes events asynchronously, through a queue.")
    public SearchException cannotConfigureSynchronizationStrategyWithIndexingEventQueue();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=800053, value="Configuration property '%1$s' is deprecated; use '%2$s' instead.")
    public void automaticIndexingStrategyIsDeprecated(String var1, String var2);

    @Message(id=800054, value="Cannot determine the set of all possible tenant identifiers. You must provide this information by setting configuration property '%1$s' to a comma-separated string containing all possible tenant identifiers.")
    public SearchException missingTenantIdConfiguration(String var1);

    @Message(id=800055, value="Cannot target tenant '%1$s' because this tenant identifier was not listed in the configuration provided on startup. To target this tenant, you must provide the tenant identifier through configuration property '%3$s', which should be set to a comma-separated string containing all possible tenant identifiers. Currently configured tenant identifiers: %2$s.")
    public SearchException invalidTenantId(String var1, Set<String> var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=800056, value="Ignoring unrecognized query hint [%s]")
    public void ignoringUnrecognizedQueryHint(String var1);

    @Message(id=800057, value="Cannot set the fetch size of Hibernate Search ScrollableResults after having created them. If you want to define the size of batches for entity loading, set loading options when defining the query instead, for example with .loading(o -> o.fetchSize(50)). See the reference documentation for more information.")
    public SearchException cannotSetFetchSize();

    @Message(id=800058, value="No matching entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not mapped in Hibernate Search. Valid identifiers for mapped entity types are: %2$s")
    public SearchException unknownTypeIdentifierForMappedEntityType(PojoRawTypeIdentifier<?> var1, Collection<PojoRawTypeIdentifier<?>> var2);

    @Message(id=800059, value="No matching indexed entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not indexed in Hibernate Search. Valid identifiers for indexed entity types are: %2$s")
    public SearchException unknownTypeIdentifierForIndexedEntityType(PojoRawTypeIdentifier<?> var1, Collection<PojoRawTypeIdentifier<?>> var2);

    @Message(id=800060, value="No matching entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not mapped in Hibernate Search. Valid classes for mapped entity types are: %2$s")
    public SearchException unknownClassForMappedEntityType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=CommaSeparatedClassesFormatter.class) Collection<Class<?>> var2);

    @Message(id=800061, value="No matching entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not mapped in Hibernate Search. Valid names for mapped entity types are: %2$s")
    public SearchException unknownEntityNameForMappedEntityType(String var1, Collection<String> var2);

    @Message(id=800062, value="No matching entity type for name '%1$s'. Either this is not the JPA name of an entity type, or the entity type is not mapped in Hibernate Search. Valid JPA names for mapped entities are: %2$s")
    public SearchException unknownJpaEntityNameForMappedEntityType(String var1, Collection<String> var2);

    @Message(id=800063, value="No matching indexed entity type for name '%1$s'. Either this is not the JPA name of an entity type, or the entity type is not indexed in Hibernate Search. Valid JPA names for indexed entities are: %2$s")
    public SearchException unknownJpaEntityNameForIndexedEntityType(String var1, Collection<String> var2);

    @Message(id=800064, value="No matching entity type for name '%1$s'. Either this is not the Hibernate ORM name of an entity type, or the entity type is not mapped in Hibernate Search. Valid Hibernate ORM names for mapped entities are: %2$s")
    public SearchException unknownHibernateOrmEntityNameForMappedEntityType(String var1, Collection<String> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=800121, value="An unexpected failure occurred while resolving the representation of path '%1$s' in the entity state array, which is necessary to configure resolution of association inverse side for reindexing. This may lead to incomplete reindexing and thus out-of-sync indexes. The exception is being ignored to preserve backwards compatibility with earlier versions of Hibernate Search. Failure: %3$s %2$s")
    public void failedToResolveStateRepresentation(String var1, @FormatWith(value=EventContextFormatter.class) EventContext var2, String var3, @Cause Exception var4);

    @Message(id=800122, value="Both '%1$s' and '%2$s' are configured. Use only '%1$s' to set the indexing plan synchronization strategy. ")
    public SearchException bothNewAndOldConfigurationPropertiesForIndexingPlanSyncAreUsed(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=800123, value="Configuration property '%1$s' is deprecated; use '%2$s' instead.")
    public void automaticIndexingSynchronizationStrategyIsDeprecated(String var1, String var2);
}

