/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.List;
import java.util.Map;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchPreIntegrationService;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategy;
import org.hibernate.search.mapper.orm.coordination.impl.CoordinationConfigurationContextImpl;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmMappingConfigurationContext;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmSearchMappingConfigurer;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapperDelegate;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingConfigurationContributor;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingPartialBuildState;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.session.impl.ConfiguredAutomaticIndexingStrategy;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMapperDelegate;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingInitiator;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;
import org.hibernate.service.ServiceRegistry;
import org.jboss.jandex.IndexView;

public class HibernateOrmMappingInitiator
extends AbstractPojoMappingInitiator<HibernateOrmMappingPartialBuildState>
implements HibernateOrmMappingConfigurationContext {
    private static final ConfigurationProperty<Boolean> MAPPING_PROCESS_ANNOTATIONS = ConfigurationProperty.forKey((String)"mapping.process_annotations").asBoolean().withDefault((Object)true).build();
    private static final ConfigurationProperty<Boolean> MAPPING_BUILD_MISSING_DISCOVERED_JANDEX_INDEXES = ConfigurationProperty.forKey((String)"mapping.build_missing_discovered_jandex_indexes").asBoolean().withDefault((Object)true).build();
    private static final OptionalConfigurationProperty<List<BeanReference<? extends HibernateOrmSearchMappingConfigurer>>> MAPPING_CONFIGURER = ConfigurationProperty.forKey((String)"mapping.configurer").asBeanReference(HibernateOrmSearchMappingConfigurer.class).multivalued().build();
    private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
    private final HibernateOrmBootstrapIntrospector introspector;
    private final HibernateSearchPreIntegrationService preIntegrationService;
    private BeanHolder<? extends CoordinationStrategy> coordinationStrategyHolder;
    private ConfiguredAutomaticIndexingStrategy configuredAutomaticIndexingStrategy;

    public static HibernateOrmMappingInitiator create(Metadata metadata, IndexView jandexIndex, ReflectionManager reflectionManager, ValueHandleFactory valueHandleFactory, ServiceRegistry serviceRegistry) {
        HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider = HibernateOrmBasicTypeMetadataProvider.create(metadata);
        HibernateOrmBootstrapIntrospector introspector = HibernateOrmBootstrapIntrospector.create(basicTypeMetadataProvider, reflectionManager, valueHandleFactory);
        ConfigurationService ormConfigurationService = HibernateOrmUtils.getServiceOrFail(serviceRegistry, ConfigurationService.class);
        HibernateSearchPreIntegrationService preIntegrationService = HibernateOrmUtils.getServiceOrFail(serviceRegistry, HibernateSearchPreIntegrationService.class);
        return new HibernateOrmMappingInitiator(basicTypeMetadataProvider, jandexIndex, introspector, ormConfigurationService, preIntegrationService);
    }

    private HibernateOrmMappingInitiator(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider, IndexView jandexIndex, HibernateOrmBootstrapIntrospector introspector, ConfigurationService ormConfigurationService, HibernateSearchPreIntegrationService preIntegrationService) {
        super((PojoBootstrapIntrospector)introspector);
        this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        if (jandexIndex != null) {
            this.annotationMapping().add(jandexIndex);
        }
        this.introspector = introspector;
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy((Map)ormConfigurationService.getSettings());
        this.tenancyMode(MultiTenancyStrategy.NONE.equals((Object)multiTenancyStrategy) ? TenancyMode.SINGLE_TENANCY : TenancyMode.MULTI_TENANCY);
        this.preIntegrationService = preIntegrationService;
    }

    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(ConfiguredAutomaticIndexingStrategy::stop, (Object)this.configuredAutomaticIndexingStrategy);
            closer.push(CoordinationStrategy::stop, this.coordinationStrategyHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.coordinationStrategyHolder);
        }
    }

    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        BeanResolver beanResolver = buildContext.beanResolver();
        ConfigurationPropertySource propertySource = buildContext.configurationPropertySource();
        this.addConfigurationContributor(new HibernateOrmMappingConfigurationContributor(this.basicTypeMetadataProvider, this.introspector));
        CoordinationConfigurationContextImpl coordinationStrategyConfiguration = this.preIntegrationService.coordinationStrategyConfiguration();
        this.coordinationStrategyHolder = coordinationStrategyConfiguration.strategyHolder();
        this.configuredAutomaticIndexingStrategy = coordinationStrategyConfiguration.createAutomaticIndexingStrategy();
        this.containedEntityIdentityMappingRequired(this.configuredAutomaticIndexingStrategy.usesAsyncProcessing());
        boolean processAnnotations = (Boolean)MAPPING_PROCESS_ANNOTATIONS.get(propertySource);
        if (processAnnotations) {
            this.annotationMapping().discoverAnnotatedTypesFromRootMappingAnnotations(true).discoverJandexIndexesFromAddedTypes(true).buildMissingDiscoveredJandexIndexes(((Boolean)MAPPING_BUILD_MISSING_DISCOVERED_JANDEX_INDEXES.get(propertySource)).booleanValue()).discoverAnnotationsFromReferencedTypes(true);
            AnnotationMappingConfigurationContext annotationMapping = this.annotationMapping();
            for (PersistentClass persistentClass : this.basicTypeMetadataProvider.getPersistentClasses()) {
                if (!persistentClass.hasPojoRepresentation()) continue;
                annotationMapping.add(persistentClass.getMappedClass());
            }
        }
        MAPPING_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0)).ifPresent(holder -> {
            try (BeanHolder configurerHolder = holder;){
                for (HibernateOrmSearchMappingConfigurer configurer : (List)configurerHolder.get()) {
                    configurer.configure(this);
                }
            }
        });
        super.configure(buildContext, configurationCollector);
    }

    protected PojoMapperDelegate<HibernateOrmMappingPartialBuildState> createMapperDelegate() {
        return new HibernateOrmMapperDelegate(this.basicTypeMetadataProvider, this.coordinationStrategyHolder, this.configuredAutomaticIndexingStrategy);
    }
}

