/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmIntegrationBooterImpl;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchPreIntegrationService;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchSessionFactoryObserver;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextProviderService;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class HibernateSearchIntegrator
implements Integrator {
    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        Optional<HibernateSearchPreIntegrationService> preIntegrationServiceOptional = HibernateOrmUtils.getServiceOrEmpty((ServiceRegistry)serviceRegistry, HibernateSearchPreIntegrationService.class);
        if (!preIntegrationServiceOptional.isPresent()) {
            return;
        }
        BootstrapContext bootstrapContext = ((MetadataImplementor)metadata).getTypeConfiguration().getMetadataBuildingContext().getBootstrapContext();
        HibernateOrmIntegrationBooterImpl booter = new HibernateOrmIntegrationBooterImpl.BuilderImpl(metadata, bootstrapContext).build();
        CompletableFuture<SessionFactoryImplementor> sessionFactoryCreatedFuture = new CompletableFuture<SessionFactoryImplementor>();
        CompletableFuture sessionFactoryClosingFuture = new CompletableFuture();
        CompletableFuture<HibernateSearchContextProviderService> contextFuture = booter.orchestrateBootAndShutdown(sessionFactoryCreatedFuture, sessionFactoryClosingFuture);
        HibernateSearchSessionFactoryObserver observer = new HibernateSearchSessionFactoryObserver(contextFuture, sessionFactoryCreatedFuture, sessionFactoryClosingFuture);
        sessionFactory.addObserver((SessionFactoryObserver)observer);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

