/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmQueryLoader;
import org.hibernate.search.mapper.orm.loading.impl.LoadingTypeContext;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.massindexing.impl.ConditionalExpression;
import org.hibernate.search.util.common.AssertionFailure;

public abstract class AbstractHibernateOrmLoadingStrategy<E, I>
implements HibernateOrmEntityLoadingStrategy<E, I> {
    private final SessionFactoryImplementor sessionFactory;
    private final EntityMappingType rootEntityMappingType;
    private final TypeQueryFactory<E, I> queryFactory;

    AbstractHibernateOrmLoadingStrategy(SessionFactoryImplementor sessionFactory, EntityMappingType rootEntityMappingType, TypeQueryFactory<E, I> queryFactory) {
        this.sessionFactory = sessionFactory;
        this.rootEntityMappingType = rootEntityMappingType;
        this.queryFactory = queryFactory;
    }

    @Override
    public HibernateOrmQueryLoader<E, I> createQueryLoader(List<LoadingTypeContext<? extends E>> typeContexts, Optional<ConditionalExpression> conditionalExpression) {
        Set<Class<Class>> includedTypesFilter;
        if (HibernateOrmUtils.targetsAllConcreteSubTypes(this.sessionFactory, this.rootEntityMappingType, typeContexts)) {
            includedTypesFilter = Collections.emptySet();
        } else {
            includedTypesFilter = new HashSet(typeContexts.size());
            for (LoadingTypeContext<E> typeContext : typeContexts) {
                includedTypesFilter.add(typeContext.typeIdentifier().javaClass());
            }
        }
        if (conditionalExpression.isPresent()) {
            if (typeContexts.size() != 1) {
                throw new AssertionFailure("conditional expression is always defined on a single type");
            }
            EntityMappingType entityMappingType = typeContexts.get(0).entityMappingType();
            return new HibernateOrmQueryLoader(this.queryFactory, entityMappingType, includedTypesFilter, conditionalExpression.get());
        }
        return new HibernateOrmQueryLoader(this.queryFactory, includedTypesFilter);
    }
}

