/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Set;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.Query;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.massindexing.impl.ConditionalExpression;

public abstract class ConditionalExpressionQueryFactory<E, I>
implements TypeQueryFactory<E, I> {
    private static final String TYPES_PARAM_NAME = "HIBERNATE_SEARCH_INCLUDED_TYPES_FILTER";
    protected final Class<I> uniquePropertyType;
    protected final String uniquePropertyName;

    public ConditionalExpressionQueryFactory(Class<I> uniquePropertyType, String uniquePropertyName) {
        this.uniquePropertyType = uniquePropertyType;
        this.uniquePropertyName = uniquePropertyName;
    }

    @Override
    public Query<Long> createQueryForCount(SharedSessionContractImplementor session, EntityMappingType entityMappingType, Set<? extends Class<? extends E>> includedTypesFilter, ConditionalExpression conditionalExpression) {
        return this.createQueryWithConditionalExpression(session, "select count(e) from " + entityMappingType.getEntityName() + " e", Long.class, "e", includedTypesFilter, conditionalExpression);
    }

    @Override
    public Query<I> createQueryForIdentifierListing(SharedSessionContractImplementor session, EntityMappingType entityMappingType, Set<? extends Class<? extends E>> includedTypesFilter, ConditionalExpression conditionalExpression) {
        return this.createQueryWithConditionalExpression(session, "select e. " + this.uniquePropertyName + " from " + entityMappingType.getEntityName() + " e", this.uniquePropertyType, "e", includedTypesFilter, conditionalExpression);
    }

    private <T> Query<T> createQueryWithConditionalExpression(SharedSessionContractImplementor session, String hql, Class<T> returnedType, String entityAlias, Set<? extends Class<? extends E>> includedTypesFilter, ConditionalExpression conditionalExpression) {
        if (includedTypesFilter.isEmpty()) {
            return this.createQueryWithConditionalExpression(session, (String)hql, returnedType, conditionalExpression);
        }
        hql = (String)hql + " where type(" + entityAlias + ") in (:HIBERNATE_SEARCH_INCLUDED_TYPES_FILTER) and ( " + conditionalExpression.hql() + " )";
        QueryImplementor query = session.createQuery((String)hql, returnedType);
        query.setParameterList(TYPES_PARAM_NAME, includedTypesFilter);
        conditionalExpression.applyParams((Query<?>)query);
        return query;
    }

    private <T> Query<T> createQueryWithConditionalExpression(SharedSessionContractImplementor session, String hql, Class<T> returnedType, ConditionalExpression conditionalExpression) {
        hql = (String)hql + " where " + conditionalExpression.hql();
        QueryImplementor query = session.createQuery((String)hql, returnedType);
        conditionalExpression.applyParams((Query<?>)query);
        return query;
    }
}

