/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.automaticindexing.impl.AutomaticIndexingTypeContextProvider;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContextProvider;
import org.hibernate.search.mapper.orm.loading.impl.LoadingIndexedTypeContextProvider;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.AbstractHibernateOrmTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmContainedTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmIndexedTypeContext;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmRawTypeIdentifierResolver;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContextProvider;
import org.hibernate.search.mapper.orm.spi.BatchTypeIdentifierProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.data.spi.KeyValueProvider;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class HibernateOrmTypeContextContainer
implements HibernateOrmListenerTypeContextProvider,
HibernateOrmSessionTypeContextProvider,
AutomaticIndexingTypeContextProvider,
LoadingIndexedTypeContextProvider,
BatchTypeIdentifierProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmRawTypeIdentifierResolver typeIdentifierResolver;
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, AbstractHibernateOrmTypeContext<?>> byTypeIdentifier;
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, HibernateOrmIndexedTypeContext<?>> indexedByTypeIdentifier;
    private final KeyValueProvider<Class<?>, AbstractHibernateOrmTypeContext<?>> byExactClass;
    private final KeyValueProvider<Class<?>, HibernateOrmIndexedTypeContext<?>> indexedByExactClass;
    private final KeyValueProvider<String, AbstractHibernateOrmTypeContext<?>> byEntityName;
    private final KeyValueProvider<String, HibernateOrmIndexedTypeContext<?>> indexedByEntityName;
    private final KeyValueProvider<String, AbstractHibernateOrmTypeContext<?>> byHibernateOrmEntityName;
    private final KeyValueProvider<String, AbstractHibernateOrmTypeContext<?>> byJpaEntityName;
    private final KeyValueProvider<String, HibernateOrmIndexedTypeContext<?>> indexedByJpaEntityName;

    private HibernateOrmTypeContextContainer(Builder builder, SessionFactoryImplementor sessionFactory) {
        PojoRawTypeIdentifier typeIdentifier;
        AbstractHibernateOrmTypeContext typeContext;
        this.typeIdentifierResolver = builder.basicTypeMetadataProvider.getTypeIdentifierResolver();
        LinkedHashMap byTypeIdentifierContent = new LinkedHashMap();
        LinkedHashMap indexedByTypeIdentifierContent = new LinkedHashMap();
        LinkedHashMap<Class, AbstractHibernateOrmTypeContext> byExactClassContent = new LinkedHashMap<Class, AbstractHibernateOrmTypeContext>();
        LinkedHashMap<Class, AbstractHibernateOrmTypeContext> indexedByExactClassContent = new LinkedHashMap<Class, AbstractHibernateOrmTypeContext>();
        LinkedHashMap<String, AbstractHibernateOrmTypeContext> byEntityNameContent = new LinkedHashMap<String, AbstractHibernateOrmTypeContext>();
        LinkedHashMap<String, AbstractHibernateOrmTypeContext> indexedByEntityNameContent = new LinkedHashMap<String, AbstractHibernateOrmTypeContext>();
        LinkedHashMap<String, AbstractHibernateOrmTypeContext> byJpaEntityNameContent = new LinkedHashMap<String, AbstractHibernateOrmTypeContext>();
        LinkedHashMap<String, AbstractHibernateOrmTypeContext> indexedByJpaEntityNameContent = new LinkedHashMap<String, AbstractHibernateOrmTypeContext>();
        LinkedHashMap<String, AbstractHibernateOrmTypeContext> byHibernateOrmEntityNameContent = new LinkedHashMap<String, AbstractHibernateOrmTypeContext>();
        for (HibernateOrmIndexedTypeContext.Builder<?> builder2 : builder.indexedTypeContextBuilders) {
            typeContext = builder2.build(sessionFactory);
            typeIdentifier = typeContext.typeIdentifier();
            byTypeIdentifierContent.put(typeIdentifier, typeContext);
            indexedByTypeIdentifierContent.put(typeIdentifier, typeContext);
            if (!typeIdentifier.isNamed()) {
                byExactClassContent.put(typeIdentifier.javaClass(), typeContext);
                indexedByExactClassContent.put(typeIdentifier.javaClass(), typeContext);
            }
            byEntityNameContent.put(typeContext.jpaEntityName(), typeContext);
            indexedByEntityNameContent.put(typeContext.jpaEntityName(), typeContext);
            byEntityNameContent.putIfAbsent(typeContext.hibernateOrmEntityName(), typeContext);
            indexedByEntityNameContent.putIfAbsent(typeContext.hibernateOrmEntityName(), typeContext);
            byJpaEntityNameContent.put(typeContext.jpaEntityName(), typeContext);
            indexedByJpaEntityNameContent.put(typeContext.jpaEntityName(), typeContext);
            byHibernateOrmEntityNameContent.put(typeContext.hibernateOrmEntityName(), typeContext);
        }
        for (HibernateOrmContainedTypeContext.Builder builder3 : builder.containedTypeContextBuilders) {
            typeContext = builder3.build(sessionFactory);
            typeIdentifier = typeContext.typeIdentifier();
            byTypeIdentifierContent.put(typeIdentifier, typeContext);
            if (!typeIdentifier.isNamed()) {
                byExactClassContent.put(typeIdentifier.javaClass(), typeContext);
            }
            byEntityNameContent.put(typeContext.jpaEntityName(), typeContext);
            byEntityNameContent.putIfAbsent(typeContext.hibernateOrmEntityName(), typeContext);
            byJpaEntityNameContent.put(typeContext.jpaEntityName(), typeContext);
            byHibernateOrmEntityNameContent.put(typeContext.hibernateOrmEntityName(), typeContext);
        }
        this.byTypeIdentifier = new KeyValueProvider(byTypeIdentifierContent, log::unknownTypeIdentifierForMappedEntityType);
        this.indexedByTypeIdentifier = new KeyValueProvider(indexedByTypeIdentifierContent, log::unknownTypeIdentifierForIndexedEntityType);
        this.byExactClass = new KeyValueProvider(byExactClassContent, log::unknownClassForMappedEntityType);
        this.indexedByExactClass = new KeyValueProvider(indexedByExactClassContent, log::unknownClassForIndexedEntityType);
        this.byEntityName = new KeyValueProvider(byEntityNameContent, log::unknownEntityNameForMappedEntityType);
        this.indexedByEntityName = new KeyValueProvider(indexedByEntityNameContent, log::unknownEntityNameForIndexedEntityType);
        this.byJpaEntityName = new KeyValueProvider(byJpaEntityNameContent, log::unknownJpaEntityNameForMappedEntityType);
        this.indexedByJpaEntityName = new KeyValueProvider(indexedByJpaEntityNameContent, log::unknownJpaEntityNameForIndexedEntityType);
        this.byHibernateOrmEntityName = new KeyValueProvider(byHibernateOrmEntityNameContent, log::unknownHibernateOrmEntityNameForMappedEntityType);
    }

    @Override
    public HibernateOrmRawTypeIdentifierResolver typeIdentifierResolver() {
        return this.typeIdentifierResolver;
    }

    public <E> AbstractHibernateOrmTypeContext<E> forExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (AbstractHibernateOrmTypeContext)this.byTypeIdentifier.getOrFail(typeIdentifier);
    }

    public <E> HibernateOrmIndexedTypeContext<E> indexedForExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (HibernateOrmIndexedTypeContext)this.indexedByTypeIdentifier.getOrFail(typeIdentifier);
    }

    public <E> AbstractHibernateOrmTypeContext<E> forExactClass(Class<E> typeIdentifier) {
        return (AbstractHibernateOrmTypeContext)this.byExactClass.getOrFail(typeIdentifier);
    }

    public <E> HibernateOrmIndexedTypeContext<E> indexedForExactClass(Class<E> typeIdentifier) {
        return (HibernateOrmIndexedTypeContext)this.indexedByExactClass.getOrFail(typeIdentifier);
    }

    public KeyValueProvider<String, AbstractHibernateOrmTypeContext<?>> byEntityName() {
        return this.byEntityName;
    }

    public KeyValueProvider<String, HibernateOrmIndexedTypeContext<?>> indexedByEntityName() {
        return this.indexedByEntityName;
    }

    public KeyValueProvider<String, AbstractHibernateOrmTypeContext<?>> byJpaEntityName() {
        return this.byJpaEntityName;
    }

    public KeyValueProvider<String, HibernateOrmIndexedTypeContext<?>> indexedByJpaEntityName() {
        return this.indexedByJpaEntityName;
    }

    public KeyValueProvider<String, AbstractHibernateOrmTypeContext<?>> byHibernateOrmEntityName() {
        return this.byHibernateOrmEntityName;
    }

    Collection<? extends HibernateOrmIndexedTypeContext<?>> allIndexed() {
        return this.indexedByTypeIdentifier.values();
    }

    static class Builder {
        private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
        private final List<HibernateOrmIndexedTypeContext.Builder<?>> indexedTypeContextBuilders = new ArrayList();
        private final List<HibernateOrmContainedTypeContext.Builder<?>> containedTypeContextBuilders = new ArrayList();

        Builder(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider) {
            this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        }

        <E> HibernateOrmIndexedTypeContext.Builder<E> addIndexed(PojoRawTypeModel<E> typeModel, String jpaEntityName) {
            HibernateOrmIndexedTypeContext.Builder<E> builder = new HibernateOrmIndexedTypeContext.Builder<E>(typeModel, jpaEntityName, this.basicTypeMetadataProvider.getHibernateOrmEntityNameByJpaEntityName(jpaEntityName));
            this.indexedTypeContextBuilders.add(builder);
            return builder;
        }

        <E> HibernateOrmContainedTypeContext.Builder<E> addContained(PojoRawTypeModel<E> typeModel, String jpaEntityName) {
            HibernateOrmContainedTypeContext.Builder<E> builder = new HibernateOrmContainedTypeContext.Builder<E>(typeModel, jpaEntityName, this.basicTypeMetadataProvider.getHibernateOrmEntityNameByJpaEntityName(jpaEntityName));
            this.containedTypeContextBuilders.add(builder);
            return builder;
        }

        HibernateOrmTypeContextContainer build(SessionFactoryImplementor sessionFactory) {
            return new HibernateOrmTypeContextContainer(this, sessionFactory);
        }
    }
}

