/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Collection;
import java.util.Set;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.Query;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.search.mapper.orm.loading.impl.ConditionalExpressionQueryFactory;

class CriteriaTypeQueryFactory<E, I>
extends ConditionalExpressionQueryFactory<E, I> {
    private final EntityDomainType<E> type;
    private final SingularAttribute<? super E, I> uniqueProperty;

    public static <E> CriteriaTypeQueryFactory<E, ?> create(EntityDomainType<E> type, String uniquePropertyName) {
        return new CriteriaTypeQueryFactory(type, type.getSingularAttribute(uniquePropertyName));
    }

    private CriteriaTypeQueryFactory(EntityDomainType<E> type, SingularAttribute<? super E, I> uniqueProperty) {
        super(uniqueProperty.getJavaType(), uniqueProperty.getName());
        this.type = type;
        this.uniqueProperty = uniqueProperty;
    }

    @Override
    public Query<Long> createQueryForCount(SharedSessionContractImplementor session, Set<? extends Class<? extends E>> includedTypesFilter) {
        HibernateCriteriaBuilder criteriaBuilder = session.getFactory().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(this.type);
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)root));
        if (!includedTypesFilter.isEmpty()) {
            criteriaQuery.where((Expression)root.type().in(includedTypesFilter));
        }
        return session.createQuery(criteriaQuery);
    }

    @Override
    public Query<I> createQueryForIdentifierListing(SharedSessionContractImplementor session, Set<? extends Class<? extends E>> includedTypesFilter) {
        HibernateCriteriaBuilder criteriaBuilder = session.getFactory().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.uniqueProperty.getJavaType());
        Root root = criteriaQuery.from(this.type);
        Path idPath = root.get(this.uniqueProperty);
        criteriaQuery.select((Selection)idPath);
        if (!includedTypesFilter.isEmpty()) {
            criteriaQuery.where((Expression)root.type().in(includedTypesFilter));
        }
        return session.createQuery(criteriaQuery);
    }

    @Override
    public Query<E> createQueryForLoadByUniqueProperty(SessionImplementor session, String parameterName) {
        HibernateCriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
        ParameterExpression idsParameter = criteriaBuilder.parameter(Collection.class, parameterName);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.type.getJavaType());
        Root root = criteriaQuery.from(this.type);
        Path uniquePropertyInRoot = root.get(this.uniqueProperty);
        criteriaQuery.where((Expression)uniquePropertyInRoot.in(new Expression[]{idsParameter}));
        return session.createQuery(criteriaQuery);
    }

    @Override
    public MultiIdentifierLoadAccess<E> createMultiIdentifierLoadAccess(SessionImplementor session) {
        return session.byMultipleIds(this.type.getJavaType());
    }

    @Override
    public boolean uniquePropertyIsTheEntityId() {
        return this.uniqueProperty.isId();
    }
}

