/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import jakarta.persistence.EntityManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassEntityLoader;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassIdentifierLoader;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassLoadingContext;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmQueryLoaderImpl;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmSelectionLoadingContext;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.loading.spi.ConditionalExpression;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmQueryLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntityLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntityLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntitySink;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierSink;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingSessionContext;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public abstract class AbstractHibernateOrmLoadingStrategy<E, I>
implements HibernateOrmEntityLoadingStrategy<E, I> {
    protected final String rootEntityName;
    protected final Class<I> uniquePropertyType;
    protected final String uniquePropertyName;
    private final GroupingAllowed groupingAllowed;

    AbstractHibernateOrmLoadingStrategy(String rootEntityName, Class<I> uniquePropertyType, String uniquePropertyName, GroupingAllowed groupingAllowed) {
        this.rootEntityName = rootEntityName;
        this.uniquePropertyType = uniquePropertyType;
        this.uniquePropertyName = uniquePropertyName;
        this.groupingAllowed = groupingAllowed;
    }

    public final PojoSelectionEntityLoader<E> createEntityLoader(Set<? extends PojoLoadingTypeContext<? extends E>> expectedTypes, PojoSelectionLoadingContext context) {
        HibernateOrmSelectionLoadingContext ormContext = (HibernateOrmSelectionLoadingContext)context;
        return this.createEntityLoader(expectedTypes, ormContext);
    }

    public abstract PojoSelectionEntityLoader<E> createEntityLoader(Set<? extends PojoLoadingTypeContext<? extends E>> var1, HibernateOrmSelectionLoadingContext var2);

    public final boolean groupingAllowed(PojoLoadingTypeContext<? extends E> type, PojoMassLoadingContext context) {
        return this.groupingAllowed.allowed(type.hasNonIndexedConcreteSubtypes()) && ((HibernateOrmMassLoadingContext)context).conditionalExpression(type).isEmpty();
    }

    public final PojoMassIdentifierLoader createIdentifierLoader(Set<? extends PojoLoadingTypeContext<? extends E>> expectedTypes, PojoMassIdentifierLoadingContext<I> context) {
        HibernateOrmMassLoadingContext ormContext = (HibernateOrmMassLoadingContext)context.parent();
        SessionFactoryImplementor sessionFactory = ormContext.mapping().sessionFactory();
        HibernateOrmQueryLoader<E, I> queryLoader = this.createQueryLoader(sessionFactory, expectedTypes, this.conditionalExpressions(expectedTypes, ormContext));
        SharedSessionContractImplementor session = (SharedSessionContractImplementor)sessionFactory.withStatelessOptions().tenantIdentifier(ormContext.tenancyConfiguration().convert(context.tenantIdentifier())).openStatelessSession();
        try {
            PojoMassIdentifierSink sink = context.createSink();
            return new HibernateOrmMassIdentifierLoader<E, I>(queryLoader, ormContext, sink, session);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(SharedSessionContract::close, (Object)session);
            throw e;
        }
    }

    public final PojoMassEntityLoader<I> createEntityLoader(Set<? extends PojoLoadingTypeContext<? extends E>> expectedTypes, PojoMassEntityLoadingContext<E> context) {
        HibernateOrmMassLoadingContext ormContext = (HibernateOrmMassLoadingContext)context.parent();
        SessionFactoryImplementor sessionFactory = ormContext.mapping().sessionFactory();
        HibernateOrmQueryLoader<E, I> queryLoader = this.createQueryLoader(sessionFactory, expectedTypes, this.conditionalExpressions(expectedTypes, ormContext));
        SessionImplementor session = (SessionImplementor)sessionFactory.withOptions().tenantIdentifier(ormContext.tenancyConfiguration().convert(context.tenantIdentifier())).openSession();
        try {
            session.setHibernateFlushMode(FlushMode.MANUAL);
            session.setCacheMode(ormContext.cacheMode());
            session.setDefaultReadOnly(true);
            PojoMassEntitySink sink = context.createSink((PojoMassIndexingSessionContext)ormContext.mapping().sessionContext((EntityManager)session));
            return new HibernateOrmMassEntityLoader(queryLoader, ormContext, sink, session);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(EntityManager::close, (Object)session);
            throw e;
        }
    }

    private List<ConditionalExpression> conditionalExpressions(Set<? extends PojoLoadingTypeContext<? extends E>> expectedTypes, HibernateOrmMassLoadingContext context) {
        if (expectedTypes.size() != 1) {
            return List.of();
        }
        Optional<ConditionalExpression> condition = context.conditionalExpression(expectedTypes.iterator().next());
        return condition.isPresent() ? List.of(condition.get()) : List.of();
    }

    @Override
    public HibernateOrmQueryLoader<E, I> createQueryLoader(SessionFactoryImplementor sessionFactory, Set<? extends PojoLoadingTypeContext<? extends E>> typeContexts, List<ConditionalExpression> conditionalExpressions) {
        return this.createQueryLoader(sessionFactory, typeContexts, conditionalExpressions, null);
    }

    @Override
    public HibernateOrmQueryLoader<E, I> createQueryLoader(SessionFactoryImplementor sessionFactory, Set<? extends PojoLoadingTypeContext<? extends E>> typeContexts, List<ConditionalExpression> conditionalExpressions, String order) {
        Set<Class<Class>> includedTypesFilter;
        EntityMappingType commonSuperType = AbstractHibernateOrmLoadingStrategy.toMostSpecificCommonEntitySuperType(sessionFactory, typeContexts);
        if (commonSuperType == null) {
            throw this.invalidTypesException(typeContexts);
        }
        if (HibernateOrmUtils.targetsAllConcreteSubTypes(sessionFactory, commonSuperType, typeContexts)) {
            includedTypesFilter = Collections.emptySet();
        } else {
            includedTypesFilter = new HashSet(typeContexts.size());
            for (PojoLoadingTypeContext<E> pojoLoadingTypeContext : typeContexts) {
                includedTypesFilter.add(pojoLoadingTypeContext.typeIdentifier().javaClass());
            }
        }
        TypeQueryFactory<E, I> actualQueryFactory = this.createFactory(commonSuperType);
        if (!conditionalExpressions.isEmpty() || order != null) {
            if (typeContexts.size() != 1) {
                throw new org.hibernate.search.util.common.AssertionFailure("conditional/order expression is always defined on a single type");
            }
            EntityMappingType entityMappingType = HibernateOrmUtils.entityMappingType(sessionFactory, typeContexts.iterator().next().secondaryEntityName());
            return new HibernateOrmQueryLoaderImpl(actualQueryFactory, entityMappingType, includedTypesFilter, conditionalExpressions, order);
        }
        return new HibernateOrmQueryLoaderImpl(actualQueryFactory, includedTypesFilter);
    }

    protected abstract TypeQueryFactory<E, I> createFactory(Class<E> var1, String var2, Class<I> var3, String var4);

    protected TypeQueryFactory<E, I> createFactory(EntityMappingType entityMappingType) {
        return this.createFactory(entityMappingType.getJavaType().getJavaTypeClass(), entityMappingType.getEntityName(), this.uniquePropertyType, this.uniquePropertyName);
    }

    protected static EntityMappingType toMostSpecificCommonEntitySuperType(SessionFactoryImplementor sessionFactory, Iterable<? extends PojoLoadingTypeContext<?>> targetEntityTypeContexts) {
        EntityMappingType result = null;
        for (PojoLoadingTypeContext<?> targetTypeContext : targetEntityTypeContexts) {
            EntityMappingType type = HibernateOrmUtils.entityMappingType(sessionFactory, targetTypeContext.secondaryEntityName());
            if (result == null) {
                result = type;
                continue;
            }
            result = HibernateOrmUtils.toMostSpecificCommonEntitySuperType(result, type);
        }
        return result;
    }

    protected AssertionFailure invalidTypesException(Set<? extends PojoLoadingTypeContext<?>> targetEntityTypeContexts) {
        return new AssertionFailure("Some types among the targeted entity types are not subclasses of the expected root entity type. Expected entity name: " + this.rootEntityName + " Targeted entity names: " + targetEntityTypeContexts.stream().map(PojoLoadingTypeContext::secondaryEntityName).collect(Collectors.toUnmodifiableList()));
    }

    static enum GroupingAllowed {
        NEVER{

            @Override
            public boolean allowed(boolean hasNonIndexedConcreteSubtypes) {
                return false;
            }
        }
        ,
        ALWAYS{

            @Override
            public boolean allowed(boolean hasNonIndexedConcreteSubtypes) {
                return true;
            }
        }
        ,
        ONLY_FOR_NO_NON_INDEXED_CONCRETE_SUBTYPES{

            @Override
            public boolean allowed(boolean hasNonIndexedConcreteSubtypes) {
                return !hasNonIndexedConcreteSubtypes;
            }
        };


        public static GroupingAllowed determine(PersistentClass persistentClass) {
            if (GroupingAllowed.isFromInheritanceType(persistentClass, JoinedSubclass.class)) {
                return ONLY_FOR_NO_NON_INDEXED_CONCRETE_SUBTYPES;
            }
            if (GroupingAllowed.isFromInheritanceType(persistentClass, SingleTableSubclass.class)) {
                return ALWAYS;
            }
            return NEVER;
        }

        private static boolean isFromInheritanceType(PersistentClass persistentClass, Class<? extends PersistentClass> kind) {
            return kind.isAssignableFrom(persistentClass.getClass()) || persistentClass instanceof RootClass && persistentClass.getSubclasses().stream().anyMatch(c -> kind.isAssignableFrom(c.getClass()));
        }

        public abstract boolean allowed(boolean var1);
    }
}

