/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicDynamicMapTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmClassRawTypeModel;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmDynamicMapRawTypeModel;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.hcann.spi.PojoHCannOrmGenericContextHelper;
import org.hibernate.search.mapper.pojo.model.spi.AbstractPojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.util.common.impl.ReflectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueCreateHandle;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public class HibernateOrmBootstrapIntrospector
extends AbstractPojoHCAnnBootstrapIntrospector
implements PojoBootstrapIntrospector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
    private final PojoHCannOrmGenericContextHelper genericContextHelper;
    private final Map<Class<?>, HibernateOrmClassRawTypeModel<?>> classTypeModelCache = new HashMap();
    private final Map<String, HibernateOrmDynamicMapRawTypeModel> dynamicMapTypeModelCache = new HashMap<String, HibernateOrmDynamicMapRawTypeModel>();

    public static HibernateOrmBootstrapIntrospector create(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider, ReflectionManager ormReflectionManager, ValueHandleFactory valueHandleFactory) {
        return new HibernateOrmBootstrapIntrospector(basicTypeMetadataProvider, ormReflectionManager, valueHandleFactory);
    }

    private HibernateOrmBootstrapIntrospector(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider, ReflectionManager reflectionManager, ValueHandleFactory valueHandleFactory) {
        super(reflectionManager, valueHandleFactory);
        this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        this.genericContextHelper = new PojoHCannOrmGenericContextHelper((AbstractPojoHCAnnBootstrapIntrospector)this);
    }

    public AbstractPojoRawTypeModel<?, ?> typeModel(String name) {
        HibernateOrmBasicDynamicMapTypeMetadata dynamicMapTypeOrmMetadata = this.basicTypeMetadataProvider.getBasicDynamicMapTypeMetadata(name);
        if (dynamicMapTypeOrmMetadata != null) {
            return this.dynamicMapTypeModelCache.computeIfAbsent(name, this::createDynamicMapTypeModel);
        }
        PersistentClass persistentClass = this.basicTypeMetadataProvider.getPersistentClass(name);
        if (persistentClass != null) {
            return this.typeModel(persistentClass.getMappedClass());
        }
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>(this.basicTypeMetadataProvider.getKnownDynamicMapTypeNames());
        typeNames.addAll(this.basicTypeMetadataProvider.getKnownHibernateOrmEntityNames());
        throw log.unknownNamedType(name, typeNames);
    }

    public <T> HibernateOrmClassRawTypeModel<T> typeModel(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ReflectionHelper.getPrimitiveWrapperType(clazz);
        }
        return this.classTypeModelCache.computeIfAbsent(clazz, this::createClassTypeModel);
    }

    protected <T> ValueCreateHandle<T> createValueCreateHandle(Constructor<T> constructor) throws IllegalAccessException {
        HibernateOrmBootstrapIntrospector.setAccessible(constructor);
        return this.valueHandleFactory.createForConstructor(constructor);
    }

    protected ValueReadHandle<?> createValueReadHandle(Member member) throws IllegalAccessException {
        HibernateOrmBootstrapIntrospector.setAccessible(member);
        return super.createValueReadHandle(member);
    }

    ValueReadHandle<?> createValueReadHandle(Class<?> holderClass, Member member, HibernateOrmBasicClassPropertyMetadata ormPropertyMetadata) throws IllegalAccessException {
        Method bytecodeEnhancerReaderMethod;
        if (member instanceof Field && ormPropertyMetadata != null && !ormPropertyMetadata.isId() && (bytecodeEnhancerReaderMethod = HibernateOrmBootstrapIntrospector.getBytecodeEnhancerReaderMethod(holderClass, (Field)member)) != null) {
            return this.createValueReadHandle(bytecodeEnhancerReaderMethod);
        }
        return this.createValueReadHandle(member);
    }

    private HibernateOrmDynamicMapRawTypeModel createDynamicMapTypeModel(String name) {
        HibernateOrmBasicDynamicMapTypeMetadata ormMetadata = this.basicTypeMetadataProvider.getBasicDynamicMapTypeMetadata(name);
        PojoRawTypeIdentifier typeIdentifier = PojoRawTypeIdentifier.of(Map.class, (String)name);
        return new HibernateOrmDynamicMapRawTypeModel(this, (PojoRawTypeIdentifier<Map>)typeIdentifier, ormMetadata);
    }

    private <T> HibernateOrmClassRawTypeModel<T> createClassTypeModel(Class<T> type) {
        HibernateOrmBasicClassTypeMetadata ormMetadataOrNull = this.basicTypeMetadataProvider.getBasicClassTypeMetadata(type);
        PojoRawTypeIdentifier typeIdentifier = PojoRawTypeIdentifier.of(type);
        return new HibernateOrmClassRawTypeModel(this, typeIdentifier, ormMetadataOrNull, new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, type));
    }

    private static void setAccessible(Member member) {
        block2: {
            try {
                ((AccessibleObject)((Object)member)).setAccessible(true);
            }
            catch (SecurityException se) {
                if (Modifier.isPublic(member.getModifiers())) break block2;
                throw se;
            }
        }
    }

    private static Method getBytecodeEnhancerReaderMethod(Class<?> holderClass, Field field) {
        if (!PersistentAttributeInterceptable.class.isAssignableFrom(holderClass)) {
            return null;
        }
        try {
            return holderClass.getMethod("$$_hibernate_read_" + field.getName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionFailure("Read method for enhanced field " + String.valueOf(field) + " is unexpectedly missing.", (Throwable)e);
        }
    }
}

