package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Locale;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import java.io.Serializable;
import java.util.Set;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.search.util.common.SearchException;
import java.util.List;
import java.lang.Class;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class ConfigurationLog_$logger implements ConfigurationLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLog_$logger.class.getName();
    public ConfigurationLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String hibernateSearchNotInitialized$str() {
        return "HSEARCH800001: Hibernate Search was not initialized.";
    }
    @Override
    public final SearchException hibernateSearchNotInitialized() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSearchNotInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidAutomaticIndexingStrategyName$str() {
        return "HSEARCH800003: Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidAutomaticIndexingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAutomaticIndexingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEntityLoadingCacheLookupStrategyName$str() {
        return "HSEARCH800018: Invalid entity loading cache lookup strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidEntityLoadingCacheLookupStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidEntityLoadingCacheLookupStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSchemaManagementStrategyName$str() {
        return "HSEARCH800032: Invalid schema management strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidSchemaManagementStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSchemaManagementStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanNotFoundInBeanContainer$str() {
        return "HSEARCH800041: No such bean in bean container '%1$s'.";
    }
    @Override
    public final BeanNotFoundException beanNotFoundInBeanContainer(final BeanContainer beanContainer) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), beanNotFoundInBeanContainer$str(), beanContainer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConfigureSynchronizationStrategyWithIndexingEventQueue$str() {
        return "HSEARCH800042: Cannot customize the indexing plan synchronization strategy:  the selected coordination strategy always processes events asynchronously, through a queue.";
    }
    @Override
    public final SearchException cannotConfigureSynchronizationStrategyWithIndexingEventQueue() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotConfigureSynchronizationStrategyWithIndexingEventQueue$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingTenantIdConfiguration$str() {
        return "HSEARCH800054: Cannot determine the set of all possible tenant identifiers. You must provide this information by setting configuration property '%1$s' to a comma-separated string containing all possible tenant identifiers.";
    }
    @Override
    public final SearchException missingTenantIdConfiguration(final String tenantIdsConfigurationPropertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingTenantIdConfiguration$str(), tenantIdsConfigurationPropertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTenantId$str() {
        return "HSEARCH800055: Cannot target tenant '%1$s' because this tenant identifier was not listed in the configuration provided on startup. To target this tenant, you must provide the tenant identifier through configuration property '%3$s', which should be set to a comma-separated string containing all possible tenant identifiers. Currently configured tenant identifiers: %2$s.";
    }
    @Override
    public final SearchException invalidTenantId(final String tenantId, final Set<String> allTenantIds, final String tenantIdsConfigurationPropertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidTenantId$str(), tenantId, allTenantIds, tenantIdsConfigurationPropertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotApplySessionFilterWhenAsyncProcessingIsUsed$str() {
        return "HSEARCH800124: Unable to apply the given filter at the session level with the outbox polling coordination strategy. With this coordination strategy, applying a session-level indexing plan filter is only allowed if it excludes all types.";
    }
    @Override
    public final SearchException cannotApplySessionFilterWhenAsyncProcessingIsUsed() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplySessionFilterWhenAsyncProcessingIsUsed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void errorResolvingBean(final Class<?> typeReference, final Exception e) {
        log.logf(FQCN, DEBUG, e, errorResolvingBean$str(), typeReference);
    }
    protected String errorResolvingBean$str() {
        return "HSEARCH800138: Error resolving bean of type [%s] - using fallback";
    }
    @Override
    public final void hibernateSearchDisabled() {
        log.logf(FQCN, DEBUG, null, hibernateSearchDisabled$str());
    }
    protected String hibernateSearchDisabled$str() {
        return "HSEARCH800139: Hibernate Search is disabled through configuration properties.";
    }
    @Override
    public final void dirtyChecksEnabled(final boolean dirtyCheckingEnabled) {
        log.logf(FQCN, DEBUG, null, dirtyChecksEnabled$str(), dirtyCheckingEnabled);
    }
    protected String dirtyChecksEnabled$str() {
        return "HSEARCH800140: Hibernate Search dirty checks: %s";
    }
    @Override
    public final void hibernateSearchListenerEnabled() {
        log.logf(FQCN, DEBUG, null, hibernateSearchListenerEnabled$str());
    }
    protected String hibernateSearchListenerEnabled$str() {
        return "HSEARCH800141: Hibernate Search event listeners activated";
    }
    @Override
    public final void hibernateSearchListenerDisabled() {
        log.logf(FQCN, DEBUG, null, hibernateSearchListenerDisabled$str());
    }
    protected String hibernateSearchListenerDisabled$str() {
        return "HSEARCH800142: Hibernate Search event listeners deactivated";
    }
}
