package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class DeprecationLog_$logger implements DeprecationLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DeprecationLog_$logger.class.getName();
    public DeprecationLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void deprecatedPropertyUsedInsteadOfNew(final String resolveOrRaw, final String resolveOrRaw1) {
        log.logf(FQCN, WARN, null, deprecatedPropertyUsedInsteadOfNew$str(), resolveOrRaw, resolveOrRaw1);
    }
    protected String deprecatedPropertyUsedInsteadOfNew$str() {
        return "HSEARCH800053: Configuration property '%1$s' is deprecated; use '%2$s' instead.";
    }
    protected String bothNewAndOldConfigurationPropertiesForIndexingPlanSyncAreUsed$str() {
        return "HSEARCH800122: Both '%1$s' and '%2$s' are configured. Use only '%1$s' to set the indexing plan synchronization strategy. ";
    }
    @Override
    public final SearchException bothNewAndOldConfigurationPropertiesForIndexingPlanSyncAreUsed(final String key1, final String key2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), bothNewAndOldConfigurationPropertiesForIndexingPlanSyncAreUsed$str(), key1, key2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void automaticIndexingSynchronizationStrategyIsDeprecated(final String deprecatedProperty, final String newProperty) {
        log.logf(FQCN, WARN, null, automaticIndexingSynchronizationStrategyIsDeprecated$str(), deprecatedProperty, newProperty);
    }
    protected String automaticIndexingSynchronizationStrategyIsDeprecated$str() {
        return "HSEARCH800123: Configuration property '%1$s' is deprecated; use '%2$s' instead.";
    }
    @Override
    public final void automaticIndexingEnableDirtyCheckIsDeprecated(final String deprecatedProperty) {
        log.logf(FQCN, WARN, null, automaticIndexingEnableDirtyCheckIsDeprecated$str(), deprecatedProperty);
    }
    protected String automaticIndexingEnableDirtyCheckIsDeprecated$str() {
        return "HSEARCH800125: Configuration property '%1$s' is deprecated. This setting will be removed in a future version. There will be no alternative provided to replace it. After the removal of this property in a future version, a dirty check will always be performed when considering whether to trigger reindexing.";
    }
    protected String bothNewAndOldConfigurationPropertiesForIndexingListenersAreUsed$str() {
        return "HSEARCH800126: Both '%1$s' and '%2$s' are configured. Use only '%2$s' to enable indexing listeners. ";
    }
    @Override
    public final SearchException bothNewAndOldConfigurationPropertiesForIndexingListenersAreUsed(final String key1, final String key2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), bothNewAndOldConfigurationPropertiesForIndexingListenersAreUsed$str(), key1, key2));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
