/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import jakarta.transaction.Synchronization;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.ScrollMode;
import org.hibernate.SessionFactory;
import org.hibernate.search.mapper.orm.logging.impl.OrmMiscLog;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.util.common.SearchException;
import org.jboss.logging.Logger;

public class OrmMiscLog_$logger
implements OrmMiscLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = OrmMiscLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public OrmMiscLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void cannotGuessTransactionStatus(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.cannotGuessTransactionStatus$str(), new Object[0]);
    }

    protected String cannotGuessTransactionStatus$str() {
        return "HSEARCH000036: Unable to guess the transaction status: not starting a JTA transaction.";
    }

    @Override
    public final void unableToCloseSearcherInScrollableResult(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseSearcherInScrollableResult$str(), new Object[0]);
    }

    protected String unableToCloseSearcherInScrollableResult$str() {
        return "HSEARCH000039: Unable to properly close scroll in ScrollableResults.";
    }

    protected String transactionNotActiveWhileProducingIdsForBatchIndexing$str() {
        return "HSEARCH000276: No transaction active. Consider increasing the connection time-out.";
    }

    @Override
    public final SearchException transactionNotActiveWhileProducingIdsForBatchIndexing() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.transactionNotActiveWhileProducingIdsForBatchIndexing$str(), new Object[0]));
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String usingDifferentSessionFactories$str() {
        return "HSEARCH800011: Unable to create a SearchSession for sessions created using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    }

    @Override
    public final SearchException usingDifferentSessionFactories(SessionFactory expectedSessionFactory, SessionFactory usedSessionFactory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String hibernateSessionAccessError$str() {
        return "HSEARCH800016: Unable to access Hibernate ORM session: %1$s";
    }

    @Override
    public final SearchException hibernateSessionAccessError(String causeMessage, IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionAccessError$str(), causeMessage), (Throwable)cause);
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String hibernateSessionIsClosed$str() {
        return "HSEARCH800017: Underlying Hibernate ORM Session is closed.";
    }

    @Override
    public final SearchException hibernateSessionIsClosed(IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionIsClosed$str(), new Object[0]), (Throwable)cause);
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(String entityName, EntityLoadingCacheLookupStrategy cacheLookupStrategy) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str(), (Object)entityName, (Object)cacheLookupStrategy);
    }

    protected String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str() {
        return "HSEARCH800019: The entity loader for '%1$s' is ignoring the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.";
    }

    @Override
    public final void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(String entityName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str(), (Object)entityName);
    }

    protected String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str() {
        return "HSEARCH800020: The entity loader for '%1$s' is ignoring the second-level cache even though it was instructed to use it, because caching is not enabled for this entity type.";
    }

    protected String hibernateSessionFactoryAccessError$str() {
        return "HSEARCH800021: Unable to access Hibernate ORM session factory: %1$s";
    }

    @Override
    public final SearchException hibernateSessionFactoryAccessError(String causeMessage, IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionFactoryAccessError$str(), causeMessage), (Throwable)cause);
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String synchronizationBeforeTransactionFailure$str() {
        return "HSEARCH800023: Unable to process entities for indexing before transaction completion: %1$s";
    }

    @Override
    public final SearchException synchronizationBeforeTransactionFailure(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.synchronizationBeforeTransactionFailure$str(), causeMessage), cause);
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String synchronizationAfterTransactionFailure$str() {
        return "HSEARCH800024: Unable to index documents for indexing after transaction completion: %1$s";
    }

    @Override
    public final SearchException synchronizationAfterTransactionFailure(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.synchronizationAfterTransactionFailure$str(), causeMessage), cause);
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String transactionHandlingException$str() {
        return "HSEARCH800025: Unable to handle transaction: %1$s";
    }

    @Override
    public final SearchException transactionHandlingException(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.transactionHandlingException$str(), causeMessage), cause);
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void shutdownFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.shutdownFailed$str(), new Object[0]);
    }

    protected String shutdownFailed$str() {
        return "HSEARCH700035: Unable to shut down Hibernate Search:";
    }

    protected String canOnlyUseScrollWithScrollModeForwardsOnly$str() {
        return "HSEARCH800036: Cannot use scroll() with scroll mode '%1$s' with Hibernate Search queries: only ScrollMode.FORWARDS_ONLY is supported.";
    }

    @Override
    public final SearchException canOnlyUseScrollWithScrollModeForwardsOnly(ScrollMode scrollMode) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.canOnlyUseScrollWithScrollModeForwardsOnly$str(), scrollMode));
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotScrollBackwards$str() {
        return "HSEARCH800037: Cannot scroll backwards with Hibernate Search scrolls: they are forwards-only. Ensure you always increment the scroll position, and never decrement it.";
    }

    @Override
    public final SearchException cannotScrollBackwards() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotScrollBackwards$str(), new Object[0]));
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotSetScrollPositionRelativeToEnd$str() {
        return "HSEARCH800038: Cannot set the scroll position relative to the end with Hibernate Search scrolls. Ensure you always pass a positive number to setRowNumber().";
    }

    @Override
    public final SearchException cannotSetScrollPositionRelativeToEnd() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotSetScrollPositionRelativeToEnd$str(), new Object[0]));
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseClosedScrollableResults$str() {
        return "HSEARCH800039: Cannot use this ScrollableResults instance: it is closed.";
    }

    @Override
    public final SearchException cannotUseClosedScrollableResults() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseClosedScrollableResults$str(), new Object[0]));
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void ignoringUnrecognizedQueryHint(String hintName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.ignoringUnrecognizedQueryHint$str(), (Object)hintName);
    }

    protected String ignoringUnrecognizedQueryHint$str() {
        return "HSEARCH800056: Ignoring unrecognized query hint [%s]";
    }

    protected String cannotSetFetchSize$str() {
        return "HSEARCH800057: Cannot set the fetch size of Hibernate Search ScrollableResults after having created them. If you want to define the size of batches for entity loading, set loading options when defining the query instead, for example with .loading(o -> o.fetchSize(50)). See the reference documentation for more information.";
    }

    @Override
    public final SearchException cannotSetFetchSize() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotSetFetchSize$str(), new Object[0]));
        OrmMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void transactionManagerNotRequired() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.transactionManagerNotRequired$str(), new Object[0]);
    }

    protected String transactionManagerNotRequired$str() {
        return "HSEARCH800127: TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction";
    }

    @Override
    public final void transactionManagerNotFound() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.transactionManagerNotFound$str(), new Object[0]);
    }

    protected String transactionManagerNotFound$str() {
        return "HSEARCH800128: No TransactionManager found, do not start a surrounding JTA transaction";
    }

    @Override
    public final void noInProgressTransaction() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.noInProgressTransaction$str(), new Object[0]);
    }

    protected String noInProgressTransaction$str() {
        return "HSEARCH800129: No Transaction in progress, needs to start a JTA transaction";
    }

    @Override
    public final void transactionAlreadyInProgress() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.transactionAlreadyInProgress$str(), new Object[0]);
    }

    protected String transactionAlreadyInProgress$str() {
        return "HSEARCH800130: Transaction in progress, no need to start a JTA transaction";
    }

    @Override
    public final void syncAdapterIgnoringAfterCompletion(Synchronization delegate) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.syncAdapterIgnoringAfterCompletion$str(), (Object)delegate);
    }

    protected String syncAdapterIgnoringAfterCompletion$str() {
        return "HSEARCH800131: Transaction's afterCompletion is expected to be executed through the AfterTransactionCompletionProcess interface, ignoring: %s";
    }

    @Override
    public final void syncAdapterIgnoringBeforeCompletionAlreadyExecuted(Synchronization delegate) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.syncAdapterIgnoringBeforeCompletionAlreadyExecuted$str(), (Object)delegate);
    }

    protected String syncAdapterIgnoringBeforeCompletionAlreadyExecuted$str() {
        return "HSEARCH800132: Transaction's beforeCompletion() phase already been processed, ignoring: %s";
    }

    @Override
    public final void syncAdapterIgnoringAfterCompletionAlreadyExecuted(Synchronization delegate) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.syncAdapterIgnoringAfterCompletionAlreadyExecuted$str(), (Object)delegate);
    }

    protected String syncAdapterIgnoringAfterCompletionAlreadyExecuted$str() {
        return "HSEARCH800133: Transaction's afterCompletion() phase already been processed, ignoring: %s";
    }
}

