package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Locale;
import org.hibernate.SessionFactory;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import jakarta.transaction.Synchronization;
import java.lang.Exception;
import org.hibernate.ScrollMode;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import java.lang.Throwable;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class OrmMiscLog_$logger implements OrmMiscLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = OrmMiscLog_$logger.class.getName();
    public OrmMiscLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cannotGuessTransactionStatus(final Exception e) {
        log.logf(FQCN, WARN, e, cannotGuessTransactionStatus$str());
    }
    protected String cannotGuessTransactionStatus$str() {
        return "HSEARCH000036: Unable to guess the transaction status: not starting a JTA transaction.";
    }
    @Override
    public final void unableToCloseSearcherInScrollableResult(final Exception e) {
        log.logf(FQCN, WARN, e, unableToCloseSearcherInScrollableResult$str());
    }
    protected String unableToCloseSearcherInScrollableResult$str() {
        return "HSEARCH000039: Unable to properly close scroll in ScrollableResults.";
    }
    protected String transactionNotActiveWhileProducingIdsForBatchIndexing$str() {
        return "HSEARCH000276: No transaction active. Consider increasing the connection time-out.";
    }
    @Override
    public final SearchException transactionNotActiveWhileProducingIdsForBatchIndexing() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), transactionNotActiveWhileProducingIdsForBatchIndexing$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String usingDifferentSessionFactories$str() {
        return "HSEARCH800011: Unable to create a SearchSession for sessions created using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    }
    @Override
    public final SearchException usingDifferentSessionFactories(final SessionFactory expectedSessionFactory, final SessionFactory usedSessionFactory) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hibernateSessionAccessError$str() {
        return "HSEARCH800016: Unable to access Hibernate ORM session: %1$s";
    }
    @Override
    public final SearchException hibernateSessionAccessError(final String causeMessage, final IllegalStateException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionAccessError$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hibernateSessionIsClosed$str() {
        return "HSEARCH800017: Underlying Hibernate ORM Session is closed.";
    }
    @Override
    public final SearchException hibernateSessionIsClosed(final IllegalStateException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionIsClosed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(final String entityName, final EntityLoadingCacheLookupStrategy cacheLookupStrategy) {
        log.logf(FQCN, DEBUG, null, skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str(), entityName, cacheLookupStrategy);
    }
    protected String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str() {
        return "HSEARCH800019: The entity loader for '%1$s' is ignoring the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.";
    }
    @Override
    public final void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(final String entityName) {
        log.logf(FQCN, DEBUG, null, skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str(), entityName);
    }
    protected String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str() {
        return "HSEARCH800020: The entity loader for '%1$s' is ignoring the second-level cache even though it was instructed to use it, because caching is not enabled for this entity type.";
    }
    protected String hibernateSessionFactoryAccessError$str() {
        return "HSEARCH800021: Unable to access Hibernate ORM session factory: %1$s";
    }
    @Override
    public final SearchException hibernateSessionFactoryAccessError(final String causeMessage, final IllegalStateException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionFactoryAccessError$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String synchronizationBeforeTransactionFailure$str() {
        return "HSEARCH800023: Unable to process entities for indexing before transaction completion: %1$s";
    }
    @Override
    public final SearchException synchronizationBeforeTransactionFailure(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), synchronizationBeforeTransactionFailure$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String synchronizationAfterTransactionFailure$str() {
        return "HSEARCH800024: Unable to index documents for indexing after transaction completion: %1$s";
    }
    @Override
    public final SearchException synchronizationAfterTransactionFailure(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), synchronizationAfterTransactionFailure$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transactionHandlingException$str() {
        return "HSEARCH800025: Unable to handle transaction: %1$s";
    }
    @Override
    public final SearchException transactionHandlingException(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), transactionHandlingException$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void shutdownFailed(final Throwable cause) {
        log.logf(FQCN, ERROR, cause, shutdownFailed$str());
    }
    protected String shutdownFailed$str() {
        return "HSEARCH700035: Unable to shut down Hibernate Search:";
    }
    protected String canOnlyUseScrollWithScrollModeForwardsOnly$str() {
        return "HSEARCH800036: Cannot use scroll() with scroll mode '%1$s' with Hibernate Search queries: only ScrollMode.FORWARDS_ONLY is supported.";
    }
    @Override
    public final SearchException canOnlyUseScrollWithScrollModeForwardsOnly(final ScrollMode scrollMode) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), canOnlyUseScrollWithScrollModeForwardsOnly$str(), scrollMode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotScrollBackwards$str() {
        return "HSEARCH800037: Cannot scroll backwards with Hibernate Search scrolls: they are forwards-only. Ensure you always increment the scroll position, and never decrement it.";
    }
    @Override
    public final SearchException cannotScrollBackwards() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotScrollBackwards$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSetScrollPositionRelativeToEnd$str() {
        return "HSEARCH800038: Cannot set the scroll position relative to the end with Hibernate Search scrolls. Ensure you always pass a positive number to setRowNumber().";
    }
    @Override
    public final SearchException cannotSetScrollPositionRelativeToEnd() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotSetScrollPositionRelativeToEnd$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseClosedScrollableResults$str() {
        return "HSEARCH800039: Cannot use this ScrollableResults instance: it is closed.";
    }
    @Override
    public final SearchException cannotUseClosedScrollableResults() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseClosedScrollableResults$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoringUnrecognizedQueryHint(final String hintName) {
        log.logf(FQCN, INFO, null, ignoringUnrecognizedQueryHint$str(), hintName);
    }
    protected String ignoringUnrecognizedQueryHint$str() {
        return "HSEARCH800056: Ignoring unrecognized query hint [%s]";
    }
    protected String cannotSetFetchSize$str() {
        return "HSEARCH800057: Cannot set the fetch size of Hibernate Search ScrollableResults after having created them. If you want to define the size of batches for entity loading, set loading options when defining the query instead, for example with .loading(o -> o.fetchSize(50)). See the reference documentation for more information.";
    }
    @Override
    public final SearchException cannotSetFetchSize() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotSetFetchSize$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void transactionManagerNotRequired() {
        log.logf(FQCN, TRACE, null, transactionManagerNotRequired$str());
    }
    protected String transactionManagerNotRequired$str() {
        return "HSEARCH800127: TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction";
    }
    @Override
    public final void transactionManagerNotFound() {
        log.logf(FQCN, TRACE, null, transactionManagerNotFound$str());
    }
    protected String transactionManagerNotFound$str() {
        return "HSEARCH800128: No TransactionManager found, do not start a surrounding JTA transaction";
    }
    @Override
    public final void noInProgressTransaction() {
        log.logf(FQCN, TRACE, null, noInProgressTransaction$str());
    }
    protected String noInProgressTransaction$str() {
        return "HSEARCH800129: No Transaction in progress, needs to start a JTA transaction";
    }
    @Override
    public final void transactionAlreadyInProgress() {
        log.logf(FQCN, TRACE, null, transactionAlreadyInProgress$str());
    }
    protected String transactionAlreadyInProgress$str() {
        return "HSEARCH800130: Transaction in progress, no need to start a JTA transaction";
    }
    @Override
    public final void syncAdapterIgnoringAfterCompletion(final Synchronization delegate) {
        log.logf(FQCN, TRACE, null, syncAdapterIgnoringAfterCompletion$str(), delegate);
    }
    protected String syncAdapterIgnoringAfterCompletion$str() {
        return "HSEARCH800131: Transaction's afterCompletion is expected to be executed through the AfterTransactionCompletionProcess interface, ignoring: %s";
    }
    @Override
    public final void syncAdapterIgnoringBeforeCompletionAlreadyExecuted(final Synchronization delegate) {
        log.logf(FQCN, TRACE, null, syncAdapterIgnoringBeforeCompletionAlreadyExecuted$str(), delegate);
    }
    protected String syncAdapterIgnoringBeforeCompletionAlreadyExecuted$str() {
        return "HSEARCH800132: Transaction's beforeCompletion() phase already been processed, ignoring: %s";
    }
    @Override
    public final void syncAdapterIgnoringAfterCompletionAlreadyExecuted(final Synchronization delegate) {
        log.logf(FQCN, TRACE, null, syncAdapterIgnoringAfterCompletionAlreadyExecuted$str(), delegate);
    }
    protected String syncAdapterIgnoringAfterCompletionAlreadyExecuted$str() {
        return "HSEARCH800133: Transaction's afterCompletion() phase already been processed, ignoring: %s";
    }
}
