/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.Transaction;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.indexing.mapper.orm", description="Logs related to the indexing process that are Hibernate ORM mapper specific.\n")
@MessageLogger(projectCode="HSEARCH")
public interface IndexingLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.indexing.mapper.orm";
    public static final IndexingLog INSTANCE = (IndexingLog)LoggerFactory.make(IndexingLog.class, (String)"org.hibernate.search.indexing.mapper.orm", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=800022, value="Indexing failure: %1$s.\nThe following entities may not have been updated correctly in the index: %2$s.")
    public SearchException indexingFailure(String var1, List<?> var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=800135, value="Processing Transaction's beforeCompletion() phase for %s.")
    public void beforeCompletion(Transaction var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=800136, value="Processing Transaction's afterCompletion() phase for %s. Executing indexing plan.")
    public void afterCompletionExecuting(Transaction var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=800137, value="Processing Transaction's afterCompletion() phase for %s. Cancelling indexing plan due to transaction status %d")
    public void afterCompletionCanceling(Transaction var1, int var2);
}

