/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.reporting.spi.BackendMappingHints;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.mapper.mapping.spi.MappingPreStopContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappingStartContext;
import org.hibernate.search.mapper.orm.automaticindexing.impl.AutomaticIndexingQueueEventProcessingPlanImpl;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingMappingContext;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingQueueEventProcessingPlan;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmEntityReference;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategy;
import org.hibernate.search.mapper.orm.entity.SearchIndexedEntity;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerContextProvider;
import org.hibernate.search.mapper.orm.logging.impl.OrmMiscLog;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.mapper.orm.mapping.context.HibernateOrmMappingContext;
import org.hibernate.search.mapper.orm.mapping.impl.AutomaticIndexingStrategyStartContextImpl;
import org.hibernate.search.mapper.orm.mapping.impl.CoordinationStrategyPreStopContextImpl;
import org.hibernate.search.mapper.orm.mapping.impl.CoordinationStrategyStartContextImpl;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmTypeContextContainer;
import org.hibernate.search.mapper.orm.mapping.spi.CoordinationStrategyContext;
import org.hibernate.search.mapper.orm.reporting.impl.HibernateOrmMappingHints;
import org.hibernate.search.mapper.orm.schema.management.SchemaManagementStrategyName;
import org.hibernate.search.mapper.orm.schema.management.impl.SchemaManagementListener;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeMappingContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeSessionContext;
import org.hibernate.search.mapper.orm.scope.impl.SearchScopeImpl;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.session.impl.ConfiguredAutomaticIndexingStrategy;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionMappingContext;
import org.hibernate.search.mapper.orm.spi.BatchMappingContext;
import org.hibernate.search.mapper.orm.tenancy.spi.TenancyConfiguration;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingDefaultCleanOperation;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgent;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgentCreateContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.work.SearchIndexingPlanFilter;
import org.hibernate.search.mapper.pojo.work.spi.ConfiguredIndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.spi.ConfiguredSearchIndexingPlanFilter;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoTypeIndexingPlan;
import org.hibernate.search.util.common.impl.Closer;

public class HibernateOrmMapping
extends AbstractPojoMappingImplementor<HibernateOrmMapping>
implements SearchMapping,
AutoCloseable,
HibernateOrmMappingContext,
HibernateOrmListenerContextProvider,
BatchMappingContext,
HibernateOrmScopeMappingContext,
HibernateOrmSearchSessionMappingContext,
AutomaticIndexingMappingContext,
CoordinationStrategyContext {
    private static final ConfigurationProperty<EntityLoadingCacheLookupStrategy> QUERY_LOADING_CACHE_LOOKUP_STRATEGY = ConfigurationProperty.forKey((String)"query.loading.cache_lookup.strategy").as(EntityLoadingCacheLookupStrategy.class, EntityLoadingCacheLookupStrategy::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.QUERY_LOADING_CACHE_LOOKUP_STRATEGY).build();
    private static final ConfigurationProperty<Integer> QUERY_LOADING_FETCH_SIZE = ConfigurationProperty.forKey((String)"query.loading.fetch_size").asIntegerStrictlyPositive().withDefault((Object)100).build();
    private static final ConfigurationProperty<SchemaManagementStrategyName> SCHEMA_MANAGEMENT_STRATEGY = ConfigurationProperty.forKey((String)"schema_management.strategy").as(SchemaManagementStrategyName.class, SchemaManagementStrategyName::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.SCHEMA_MANAGEMENT_STRATEGY).build();
    private static final ConfigurationProperty<MassIndexingDefaultCleanOperation> INDEXING_MASS_DEFAULT_CLEAN_OPERATION = ConfigurationProperty.forKey((String)"indexing.mass.default_clean_operation").as(MassIndexingDefaultCleanOperation.class, MassIndexingDefaultCleanOperation::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.INDEXING_MASS_DEFAULT_CLEAN_OPERATION).build();
    private final SessionFactoryImplementor sessionFactory;
    private final HibernateOrmTypeContextContainer typeContextContainer;
    private final BeanHolder<? extends CoordinationStrategy> coordinationStrategyHolder;
    private final ConfiguredAutomaticIndexingStrategy configuredAutomaticIndexingStrategy;
    private final EntityLoadingCacheLookupStrategy cacheLookupStrategy;
    private final int fetchSize;
    private final SchemaManagementListener schemaManagementListener;
    private final MassIndexingDefaultCleanOperation massIndexingDefaultCleanOperation;
    private volatile ConfiguredSearchIndexingPlanFilter applicationIndexingPlanFilter = ConfiguredSearchIndexingPlanFilter.IncludeAll.INSTANCE;
    private TenancyConfiguration tenancyConfiguration;
    private SearchIntegration.Handle integrationHandle;
    private volatile boolean listenerEnabled = true;

    public static MappingImplementor<HibernateOrmMapping> create(PojoMappingDelegate mappingDelegate, HibernateOrmTypeContextContainer typeContextContainer, BeanHolder<? extends CoordinationStrategy> coordinationStrategyHolder, ConfiguredAutomaticIndexingStrategy configuredAutomaticIndexingStrategy, SessionFactoryImplementor sessionFactory, ConfigurationPropertySource propertySource) {
        EntityLoadingCacheLookupStrategy cacheLookupStrategy = (EntityLoadingCacheLookupStrategy)((Object)QUERY_LOADING_CACHE_LOOKUP_STRATEGY.get(propertySource));
        int fetchSize = (Integer)QUERY_LOADING_FETCH_SIZE.get(propertySource);
        SchemaManagementStrategyName schemaManagementStrategyName = (SchemaManagementStrategyName)((Object)SCHEMA_MANAGEMENT_STRATEGY.get(propertySource));
        SchemaManagementListener schemaManagementListener = new SchemaManagementListener(schemaManagementStrategyName);
        MassIndexingDefaultCleanOperation massIndexingDefaultCleanOperation = (MassIndexingDefaultCleanOperation)INDEXING_MASS_DEFAULT_CLEAN_OPERATION.get(propertySource);
        return new HibernateOrmMapping(mappingDelegate, typeContextContainer, sessionFactory, coordinationStrategyHolder, configuredAutomaticIndexingStrategy, cacheLookupStrategy, fetchSize, schemaManagementListener, massIndexingDefaultCleanOperation);
    }

    private HibernateOrmMapping(PojoMappingDelegate mappingDelegate, HibernateOrmTypeContextContainer typeContextContainer, SessionFactoryImplementor sessionFactory, BeanHolder<? extends CoordinationStrategy> coordinationStrategyHolder, ConfiguredAutomaticIndexingStrategy configuredAutomaticIndexingStrategy, EntityLoadingCacheLookupStrategy cacheLookupStrategy, int fetchSize, SchemaManagementListener schemaManagementListener, MassIndexingDefaultCleanOperation massIndexingDefaultCleanOperation) {
        super(mappingDelegate, HibernateOrmEntityReference::new);
        this.typeContextContainer = typeContextContainer;
        this.sessionFactory = sessionFactory;
        this.coordinationStrategyHolder = coordinationStrategyHolder;
        this.configuredAutomaticIndexingStrategy = configuredAutomaticIndexingStrategy;
        this.cacheLookupStrategy = cacheLookupStrategy;
        this.fetchSize = fetchSize;
        this.schemaManagementListener = schemaManagementListener;
        this.massIndexingDefaultCleanOperation = massIndexingDefaultCleanOperation;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(SearchIntegration::close, (Object)this.integrationHandle, SearchIntegration.Handle::getOrNull);
            this.integrationHandle = null;
        }
    }

    public CompletableFuture<?> start(MappingStartContext context) {
        this.integrationHandle = context.integrationHandle();
        this.configuredAutomaticIndexingStrategy.start(this, new AutomaticIndexingStrategyStartContextImpl(context), this);
        Optional<SearchScopeImpl<Object, Object>> scopeOptional = this.createAllScope();
        if (!scopeOptional.isPresent()) {
            return CompletableFuture.completedFuture(null);
        }
        SearchScopeImpl<Object, Object> scope = scopeOptional.get();
        this.tenancyConfiguration = TenancyConfiguration.create(context.beanResolver(), this.delegate().tenancyMode(), context.configurationPropertySource());
        PojoScopeSchemaManager schemaManager = scope.schemaManagerDelegate();
        return this.schemaManagementListener.onStart(context, schemaManager).thenCompose(ignored -> ((CoordinationStrategy)this.coordinationStrategyHolder.get()).start(new CoordinationStrategyStartContextImpl(this, context, this.tenancyConfiguration)));
    }

    public CompletableFuture<?> preStop(MappingPreStopContext context) {
        Optional<SearchScopeImpl<Object, Object>> scope = this.createAllScope();
        if (!scope.isPresent()) {
            return CompletableFuture.completedFuture(null);
        }
        PojoScopeSchemaManager schemaManager = scope.get().schemaManagerDelegate();
        return ((CoordinationStrategy)this.coordinationStrategyHolder.get()).preStop(new CoordinationStrategyPreStopContextImpl(context)).thenCompose(ignored -> this.schemaManagementListener.onStop(context, schemaManager));
    }

    protected void doStop() {
        try (Closer closer = new Closer();){
            closer.push(ConfiguredAutomaticIndexingStrategy::stop, (Object)this.configuredAutomaticIndexingStrategy);
            closer.push(CoordinationStrategy::stop, this.coordinationStrategyHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.coordinationStrategyHolder);
            closer.push(TenancyConfiguration::close, (Object)this.tenancyConfiguration);
        }
    }

    public BackendMappingHints hints() {
        return HibernateOrmMappingHints.INSTANCE;
    }

    public <SR, T> SearchScopeImpl<SR, T> scope(Class<T> clazz) {
        return this.scope(Collections.singleton(clazz));
    }

    public <SR, T> SearchScopeImpl<SR, T> scope(Class<T> expectedSuperType, String entityName) {
        return this.scope((Class)expectedSuperType, Collections.singleton(entityName));
    }

    public <SR, T> SearchScopeImpl<SR, T> scope(Collection<? extends Class<? extends T>> classes) {
        return this.createScope(classes);
    }

    public <SR, T> SearchScopeImpl<SR, T> scope(Class<T> expectedSuperType, Collection<String> entityNames) {
        return this.createScope(expectedSuperType, entityNames);
    }

    @Override
    public EntityManagerFactory toEntityManagerFactory() {
        return this.sessionFactory;
    }

    @Override
    public SessionFactory toOrmSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public <E> SearchIndexedEntity<E> indexedEntity(Class<E> entityType) {
        return this.typeContextContainer.indexedForExactClass(entityType);
    }

    @Override
    public SearchIndexedEntity<?> indexedEntity(String entityName) {
        return (SearchIndexedEntity)this.typeContextContainer.indexedByEntityName().getOrFail((Object)entityName);
    }

    public Collection<SearchIndexedEntity<?>> allIndexedEntities() {
        return Collections.unmodifiableCollection(this.typeContextContainer.allIndexed());
    }

    @Override
    public IndexManager indexManager(String indexName) {
        return this.searchIntegration().indexManager(indexName);
    }

    @Override
    public Backend backend() {
        return this.searchIntegration().backend();
    }

    @Override
    public Backend backend(String backendName) {
        return this.searchIntegration().backend(backendName);
    }

    @Override
    public void indexingPlanFilter(SearchIndexingPlanFilter filter) {
        this.applicationIndexingPlanFilter = this.delegate().configuredSearchIndexingPlanFilter(filter, null);
    }

    @Override
    public ConfiguredSearchIndexingPlanFilter applicationIndexingPlanFilter() {
        return this.applicationIndexingPlanFilter;
    }

    @Override
    public ConfiguredSearchIndexingPlanFilter configuredSearchIndexingPlanFilter(SearchIndexingPlanFilter filter) {
        return this.delegate().configuredSearchIndexingPlanFilter(filter, this.applicationIndexingPlanFilter);
    }

    public HibernateOrmMapping toConcreteType() {
        return this;
    }

    @Override
    public EntityLoadingCacheLookupStrategy cacheLookupStrategy() {
        return this.cacheLookupStrategy;
    }

    @Override
    public int fetchSize() {
        return this.fetchSize;
    }

    @Override
    public SessionFactoryImplementor sessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public TenancyConfiguration tenancyConfiguration() {
        return this.tenancyConfiguration;
    }

    @Override
    public MassIndexingDefaultCleanOperation massIndexingDefaultCleanOperation() {
        return this.massIndexingDefaultCleanOperation;
    }

    @Override
    public HibernateOrmScopeSessionContext sessionContext(EntityManager entityManager) {
        return HibernateOrmSearchSession.get(this, HibernateOrmUtils.toSessionImplementor(entityManager));
    }

    @Override
    public boolean listenerEnabled() {
        return this.listenerEnabled;
    }

    public void listenerEnabled(boolean enabled) {
        this.listenerEnabled = enabled;
    }

    public CompletableFuture<?> backgroundIndexingCompletion() {
        return ((CoordinationStrategy)this.coordinationStrategyHolder.get()).completion();
    }

    public PojoMassIndexerAgent createMassIndexerAgent(PojoMassIndexerAgentCreateContext context) {
        return ((CoordinationStrategy)this.coordinationStrategyHolder.get()).createMassIndexerAgent(context);
    }

    @Override
    public PojoIndexingPlan currentIndexingPlanIfExisting(SessionImplementor session) {
        HibernateOrmSearchSession searchSession = HibernateOrmSearchSession.get(this, session, false);
        if (searchSession == null) {
            return null;
        }
        return searchSession.currentIndexingPlan(false);
    }

    @Override
    public PojoTypeIndexingPlan currentIndexingPlanIfTypeIncluded(SessionImplementor session, PojoRawTypeIdentifier<?> typeIdentifier) {
        HibernateOrmSearchSession searchSession = HibernateOrmSearchSession.get(this, session, false);
        if (searchSession != null) {
            if (searchSession.configuredIndexingPlanFilter().isIncluded(typeIdentifier)) {
                return searchSession.currentIndexingPlan(true).typeIfIncludedOrNull(typeIdentifier);
            }
            return null;
        }
        if (this.applicationIndexingPlanFilter.isIncluded(typeIdentifier)) {
            searchSession = HibernateOrmSearchSession.get(this, session, true);
            return searchSession.currentIndexingPlan(true).typeIfIncludedOrNull(typeIdentifier);
        }
        return null;
    }

    @Override
    public AutomaticIndexingQueueEventProcessingPlan createIndexingQueueEventProcessingPlan(Session session) {
        HibernateOrmSearchSession searchSession = HibernateOrmSearchSession.get(this, (SessionImplementor)session.unwrap(SessionImplementor.class), true);
        return new AutomaticIndexingQueueEventProcessingPlanImpl(searchSession.createIndexingQueueEventProcessingPlan());
    }

    @Override
    public ConfiguredIndexingPlanSynchronizationStrategy currentAutomaticIndexingSynchronizationStrategy(SessionImplementor session) {
        return HibernateOrmSearchSession.get(this, session).configuredAutomaticIndexingSynchronizationStrategy();
    }

    @Override
    public HibernateOrmTypeContextContainer typeContextProvider() {
        return this.typeContextContainer;
    }

    @Override
    public <SR, T> SearchScopeImpl<SR, T> createScope(Collection<? extends Class<? extends T>> classes) {
        PojoScopeDelegate scopeDelegate = this.delegate().createPojoScopeForClasses((PojoScopeMappingContext)this, classes, this.typeContextContainer::indexedForExactType);
        return new SearchScopeImpl(this, this.tenancyConfiguration, scopeDelegate);
    }

    @Override
    public <SR, T> SearchScopeImpl<SR, T> createScope(Class<T> expectedSuperType, Collection<String> entityNames) {
        PojoScopeDelegate scopeDelegate = this.delegate().createPojoScopeForEntityNames((PojoScopeMappingContext)this, expectedSuperType, entityNames, this.typeContextContainer::indexedForExactType);
        return new SearchScopeImpl(this, this.tenancyConfiguration, scopeDelegate);
    }

    @Override
    public HibernateOrmSearchSession.Builder createSessionBuilder(SessionImplementor sessionImplementor) {
        SessionFactoryImplementor givenSessionFactory = sessionImplementor.getSessionFactory();
        if (!givenSessionFactory.equals((Object)this.sessionFactory)) {
            throw OrmMiscLog.INSTANCE.usingDifferentSessionFactories((SessionFactory)this.sessionFactory, (SessionFactory)givenSessionFactory);
        }
        return new HibernateOrmSearchSession.Builder(this, this.typeContextContainer, this.configuredAutomaticIndexingStrategy, sessionImplementor);
    }

    @Override
    public CoordinationStrategy coordinationStrategy() {
        return (CoordinationStrategy)this.coordinationStrategyHolder.get();
    }

    private SearchIntegration searchIntegration() {
        return this.integrationHandle.getOrFail();
    }

    private Optional<SearchScopeImpl<Object, Object>> createAllScope() {
        return this.delegate().createPojoAllScope((PojoScopeMappingContext)this, this.typeContextContainer::indexedForExactType).map(scopeDelegate -> new SearchScopeImpl(this, this.tenancyConfiguration, scopeDelegate));
    }
}

