package org.hibernate.search.mapper.pojo.logging.impl;

import java.util.Locale;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import java.io.Serializable;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import java.net.MalformedURLException;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeOptionsStep;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import java.net.URISyntaxException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.jboss.logging.BasicLogger;
import java.util.Collection;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String uselessIncludePathFilters$str() {
        return "HSEARCH000216: An IndexedEmbedded defines includePaths filters that do not match anything. Non-matching includePaths filters: %1$s. Encountered field paths: %2$s. Check the filters for typos, or remove them if they are not useful.";
    }
    @Override
    public final SearchException uselessIncludePathFilters(final Set<String> nonMatchingIncludePaths, final Set<String> encounteredFieldPaths, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), uselessIncludePathFilters$str(), nonMatchingIncludePaths, encounteredFieldPaths), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String parseException$str() {
        return "HSEARCH000295: String '$1%s' cannot be parsed into a '$2%s'";
    }
    @Override
    public final SearchException parseException(final String text, final Class<?> readerClass, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), parseException$str(), text, new org.hibernate.search.util.common.logging.impl.ClassFormatter(readerClass)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String valueTooLargeForConversionException$str() {
        return "HSEARCH000297:  Value of '%2$s' for type '%1$s' is too big for the conversion";
    }
    @Override
    public final SearchException valueTooLargeForConversionException(final Class<?> type, final Object duration, final Exception ae) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), valueTooLargeForConversionException$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(type), duration), ae);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToResolveDefaultIdentifierBridgeFromSourceType$str() {
        return "HSEARCH700001: Unable to find a default identifier bridge implementation for type '%1$s'";
    }
    @Override
    public final SearchException unableToResolveDefaultIdentifierBridgeFromSourceType(final PojoTypeModel<?> sourceType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToResolveDefaultIdentifierBridgeFromSourceType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(sourceType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToResolveDefaultValueBridgeFromSourceType$str() {
        return "HSEARCH700002: Unable to find a default value bridge implementation for type '%1$s'";
    }
    @Override
    public final SearchException unableToResolveDefaultValueBridgeFromSourceType(final PojoTypeModel<?> sourceType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToResolveDefaultValueBridgeFromSourceType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(sourceType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingBinderReferenceInBinding$str() {
        return "HSEARCH700003: The binder reference is empty.";
    }
    @Override
    public final SearchException missingBinderReferenceInBinding() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBinderReferenceInBinding$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldDefiningBothBridgeReferenceAndBinderReference$str() {
        return "HSEARCH700005: The field annotation defines both valueBridge and valueBinder. Only one of those can be defined, not both.";
    }
    @Override
    public final SearchException invalidFieldDefiningBothBridgeReferenceAndBinderReference() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldDefiningBothBridgeReferenceAndBinderReference$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference$str() {
        return "HSEARCH700006: @DocumentId defines both identifierBridge and identifierBinder. Only one of those can be defined, not both.";
    }
    @Override
    public final SearchException invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEmptyTargetForScope$str() {
        return "HSEARCH700007: Invalid empty target for a scoped operation. If you want to target all indexes, use 'Object.class' as the target type.";
    }
    @Override
    public final SearchException invalidEmptyTargetForScope() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidEmptyTargetForScope$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidInputTypeForBridge$str() {
        return "HSEARCH700010: Bridge '%1$s' cannot be applied to input type '%2$s'.";
    }
    @Override
    public final SearchException invalidInputTypeForBridge(final Object bridge, final PojoTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidInputTypeForBridge$str(), bridge, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingFieldNameForGeoPointBridgeOnType$str() {
        return "HSEARCH700011: Missing field name for GeoPointBinding on type %1$s. The field name is mandatory when the bridge is applied on an type, optional when applied on a property.";
    }
    @Override
    public final SearchException missingFieldNameForGeoPointBridgeOnType(final String typeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingFieldNameForGeoPointBridgeOnType$str(), typeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInferContainerExtractorClassTypePattern$str() {
        return "HSEARCH700015: Cannot interpret the type arguments to the ContainerExtractor interface in  implementation '%1$s'. Only the following implementations of ContainerExtractor are valid:  1) implementations setting both type parameters to *raw* types, e.g. class MyExtractor implements ContainerExtractor<MyBean, String>; 2) implementations setting the first type parameter to an array of an unbounded type variable, and setting the second parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<T[], T> 3) implementations setting the first type parameter to a parameterized type with one argument set to an unbounded type variable and the other to unbounded wildcards, and setting the second type parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<MyParameterizedBean<?, T, ?>, T>";
    }
    @Override
    public final SearchException cannotInferContainerExtractorClassTypePattern(final Class<?> extractorClass, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotInferContainerExtractorClassTypePattern$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(extractorClass)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidContainerExtractorForType$str() {
        return "HSEARCH700016: Cannot apply the requested container value extractor '%1$s' (implementation class: '%2$s') to type '%3$s'";
    }
    @Override
    public final SearchException invalidContainerExtractorForType(final String extractorName, final Class<? extends org.hibernate.search.mapper.pojo.extractor.ContainerExtractor> extractorClass, final PojoGenericTypeModel<?> extractedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContainerExtractorForType$str(), extractorName, new org.hibernate.search.util.common.logging.impl.ClassFormatter(extractorClass), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(extractedType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void createdPojoIndexedTypeManager(final PojoIndexedTypeManager<?, ?> typeManager) {
        super.log.logf(FQCN, DEBUG, null, createdPojoIndexedTypeManager$str(), new org.hibernate.search.util.common.logging.impl.ToStringTreeAppendableMultilineFormatter(typeManager));
    }
    protected String createdPojoIndexedTypeManager$str() {
        return "HSEARCH700017: Created POJO indexed type manager: %1$s";
    }
    @Override
    public final void detectedEntityTypes(final Set<PojoRawTypeModel<?>> entityTypes, final Set<PojoRawTypeModel<?>> indexedTypes) {
        super.log.logf(FQCN, DEBUG, null, detectedEntityTypes$str(), entityTypes, indexedTypes);
    }
    protected String detectedEntityTypes$str() {
        return "HSEARCH700018: Detected entity types: %1$s, indexed types: %2$s";
    }
    @Override
    public final void createdPojoContainedTypeManager(final PojoContainedTypeManager<?> typeManager) {
        super.log.logf(FQCN, DEBUG, null, createdPojoContainedTypeManager$str(), new org.hibernate.search.util.common.logging.impl.ToStringTreeAppendableMultilineFormatter(typeManager));
    }
    protected String createdPojoContainedTypeManager$str() {
        return "HSEARCH700019: Created POJO contained type manager: %1$s";
    }
    protected String cannotInvertAssociationForReindexing$str() {
        return "HSEARCH700020: Cannot find the inverse side of the association on type '%2$s' at path '%3$s'. Hibernate Search needs this information in order to reindex '%2$s' when '%1$s' is modified. You can solve this error by defining the inverse side of this association,  either with annotations specific to your integration (@OneToMany(mappedBy = ...) in Hibernate ORM)  or with the Hibernate Search @AssociationInverseSide annotation. Alternatively, if you do not need to reindex '%2$s' when '%1$s' is modified, you can disable reindexing with @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO).";
    }
    @Override
    public final SearchException cannotInvertAssociationForReindexing(final PojoRawTypeModel<?> inverseSideTypeModel, final PojoRawTypeModel<?> typeModel, final PojoModelPathValueNode associationPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotInvertAssociationForReindexing$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(associationPath)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotApplyImplicitInverseAssociationPath$str() {
        return "HSEARCH700021: Cannot apply the path '%2$s' to type '%1$s'. This path was resolved as the inverse side of the association '%4$s' on type '%3$s'. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Error was: '%5$s'";
    }
    @Override
    public final SearchException cannotApplyImplicitInverseAssociationPath(final PojoRawTypeModel<?> inverseSideTypeModel, final PojoModelPathValueNode inverseSideAssociationPath, final PojoRawTypeModel<?> originalSideTypeModel, final PojoModelPathValueNode originalSideAssociationPath, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyImplicitInverseAssociationPath$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(inverseSideAssociationPath), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(originalSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(originalSideAssociationPath), errorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incorrectTargetTypeForInverseAssociation$str() {
        return "HSEARCH700022: The inverse association targets type '%1$s', but a supertype or subtype of '%2$s' was expected.";
    }
    @Override
    public final SearchException incorrectTargetTypeForInverseAssociation(final PojoRawTypeModel<?> inverseAssociationTargetType, final PojoRawTypeModel<?> entityType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incorrectTargetTypeForInverseAssociation$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseAssociationTargetType), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(entityType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingInversePathInAssociationInverseSideMapping$str() {
        return "HSEARCH700023: @AssociationInverseSide.inversePath is empty.";
    }
    @Override
    public final SearchException missingInversePathInAssociationInverseSideMapping() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingInversePathInAssociationInverseSideMapping$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String infiniteRecursionForAssociationEmbeddeds$str() {
        return "HSEARCH700024: Found an infinite embedded recursion involving path '%2$s' on type '%1$s'";
    }
    @Override
    public final SearchException infiniteRecursionForAssociationEmbeddeds(final PojoRawTypeModel<?> typeModel, final PojoModelPathValueNode path) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), infiniteRecursionForAssociationEmbeddeds$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(path)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingEntityTypeMetadata$str() {
        return "HSEARCH700027: Type '%1$s' is not marked as an entity type and is not abstract, yet it is indexed or targeted by an association from an indexed type. Please check your configuration.";
    }
    @Override
    public final SearchException missingEntityTypeMetadata(final PojoRawTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingEntityTypeMetadata$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingIdentifierMapping$str() {
        return "HSEARCH700028: There isn't any explicit document ID mapping for indexed type '%1$s', and the entity ID cannot be used as a default because the property representing the entity ID cannot be found.";
    }
    @Override
    public final SearchException missingIdentifierMapping(final PojoRawTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingIdentifierMapping$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingPathInIndexingDependencyDerivedFrom$str() {
        return "HSEARCH700029: @IndexingDependency.derivedFrom contains an empty path.";
    }
    @Override
    public final SearchException missingPathInIndexingDependencyDerivedFrom() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingPathInIndexingDependencyDerivedFrom$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String infiniteRecursionForDerivedFrom$str() {
        return "HSEARCH700030: Found a cyclic dependency between derived properties involving path '%2$s' on type '%1$s'. Derived properties cannot be marked as derived from themselves, even indirectly through other  derived properties. If your model actually contains such cyclic dependency,  you should consider disabling automatic reindexing, at least partially  using @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO) on one of the properties in the cycle.";
    }
    @Override
    public final SearchException infiniteRecursionForDerivedFrom(final PojoRawTypeModel<?> typeModel, final PojoModelPathValueNode path) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), infiniteRecursionForDerivedFrom$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(path)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldEncodingForStringFieldMapping$str() {
        return "HSEARCH700031: This property's mapping expects a standard String type for the index field, but the assigned value bridge or value binder declares a non-standard or non-String type. Make sure to use a compatible bridge or binder. Details: encountered type DSL step '%1$s', which does not extend the expected '%2$s' interface.";
    }
    @Override
    public final SearchException invalidFieldEncodingForStringFieldMapping(final IndexFieldTypeOptionsStep<?, ?> step, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForStringFieldMapping$str(), step, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String propertyMarkerNotFound$str() {
        return "HSEARCH700034: Could not find a property with the '%1$s' marker for field '%2$s' (marker set: '%3$s').";
    }
    @Override
    public final SearchException propertyMarkerNotFound(final String markerName, final String fieldName, final String markerSet) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), propertyMarkerNotFound$str(), markerName, fieldName, markerSet));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiplePropertiesForMarker$str() {
        return "HSEARCH700035: Found multiple properties with the '%1$s' marker for field '%2$s' (marker set: '%3$s').";
    }
    @Override
    public final SearchException multiplePropertiesForMarker(final String markerName, final String fieldName, final String markerSet) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiplePropertiesForMarker$str(), markerName, fieldName, markerSet));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidScopeTarget$str() {
        return "HSEARCH700036: Some of the given types cannot be targeted. These types are not indexed, nor is any of their subtypes: %1$s. Note that some of them are indexed-embedded in an indexed entity, but this is not enough to be targeted (only indexed types can be targeted): %2$s.";
    }
    @Override
    public final SearchException invalidScopeTarget(final Collection<PojoRawTypeIdentifier<?>> nonIndexedTypes, final Collection<PojoRawTypeIdentifier<?>> containedTypes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidScopeTarget$str(), nonIndexedTypes, containedTypes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notIndexedTypeNorAsDelegate$str() {
        return "HSEARCH700037: Cannot work on type '%1$s', because it is not indexed, neither directly nor as a contained entity in another type.";
    }
    @Override
    public final SearchException notIndexedTypeNorAsDelegate(final PojoRawTypeIdentifier<?> targetedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notIndexedTypeNorAsDelegate$str(), targetedType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullProvidedIdentifier$str() {
        return "HSEARCH700038: The identifier for this entity should always be provided, but the provided identifier was null.";
    }
    @Override
    public final SearchException nullProvidedIdentifier() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullProvidedIdentifier$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompatibleRequestedType$str() {
        return "HSEARCH700039: Requested incompatible type for '%1$s': '%2$s'";
    }
    @Override
    public final SearchException incompatibleRequestedType(final PojoModelPathValueNode accessor, final Class<?> requestedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompatibleRequestedType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(accessor), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notDirectlyIndexedType$str() {
        return "HSEARCH700040: Cannot work on type '%1$s', because it is not directly indexed.";
    }
    @Override
    public final SearchException notDirectlyIndexedType(final PojoRawTypeIdentifier<?> targetedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notDirectlyIndexedType$str(), targetedType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseDefaultExtractorsInMultiExtractorChain$str() {
        return "HSEARCH700041: A chain of multiple container extractors cannot include the default extractors. Either use only the default extractors, or explicitly reference every single extractor to be applied instead.";
    }
    @Override
    public final SearchException cannotUseDefaultExtractorsInMultiExtractorChain() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseDefaultExtractorsInMultiExtractorChain$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String malformedURL$str() {
        return "HSEARCH700043: Error creating URL from String '%1$s'.";
    }
    @Override
    public final SearchException malformedURL(final String value, final MalformedURLException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), malformedURL$str(), value), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String badURISyntax$str() {
        return "HSEARCH700044: Error creating URI from String '%1$s'.";
    }
    @Override
    public final SearchException badURISyntax(final String value, final URISyntaxException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), badURISyntax$str(), value), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDefinePojoModelPathWithoutProperty$str() {
        return "HSEARCH700045: A PojoModelPath must include at least one property.";
    }
    @Override
    public final SearchException cannotDefinePojoModelPathWithoutProperty() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotDefinePojoModelPathWithoutProperty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotApplyExplicitInverseAssociationPath$str() {
        return "HSEARCH700046: Cannot apply the path '%2$s' to type '%1$s'. This path was declared as a path to collect entities of type '%3$s' to be reindexed. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Error was: '%4$s'";
    }
    @Override
    public final SearchException cannotApplyExplicitInverseAssociationPath(final PojoRawTypeModel<?> inverseSideTypeModel, final PojoModelPathValueNode inverseSideAssociationPath, final PojoRawTypeModel<?> originalSideTypeModel, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyExplicitInverseAssociationPath$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(inverseSideAssociationPath), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(originalSideTypeModel), errorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDefineOtherEntityDependencyOnNonEntityBridgedType$str() {
        return "HSEARCH700047: 'fromOtherEntity' can only be used when the bridged element has an entity type, but the bridged element has type '%1$s', which is not an entity type.";
    }
    @Override
    public final SearchException cannotDefineOtherEntityDependencyOnNonEntityBridgedType(final PojoRawTypeModel<?> bridgedTypeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotDefineOtherEntityDependencyOnNonEntityBridgedType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(bridgedTypeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDefineOtherEntityDependencyFromNonEntityType$str() {
        return "HSEARCH700048: 'fromOtherEntity' expects an entity type; type '%1$s' is not an entity type.";
    }
    @Override
    public final SearchException cannotDefineOtherEntityDependencyFromNonEntityType(final PojoRawTypeModel<?> otherType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotDefineOtherEntityDependencyFromNonEntityType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(otherType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingBridgeDependencyDeclaration$str() {
        return "HSEARCH700049: The binder did not declare any dependency to the entity model during binding. Declare dependencies using context.dependencies().use(...) or, if the bridge really does not depend on the entity model, context.dependencies().useRootOnly().";
    }
    @Override
    public final SearchException missingBridgeDependencyDeclaration() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBridgeDependencyDeclaration$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inconsistentBridgeDependencyDeclaration$str() {
        return "HSEARCH700050: The binder called context.dependencies().useRootOnly() during binding, but also declared extra dependencies to the entity model.";
    }
    @Override
    public final SearchException inconsistentBridgeDependencyDeclaration() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), inconsistentBridgeDependencyDeclaration$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldEncodingForScaledNumberFieldMapping$str() {
        return "HSEARCH700051: This property's mapping expects a scaled number type (BigDecimal or BigInteger) for the index field, but the assigned value bridge or value binder declares a non-scaled type. Make sure to use a compatible bridge or binder. Details: encountered type DSL step '%1$s', which does not extend the expected '%2$s' interface.";
    }
    @Override
    public final SearchException invalidFieldEncodingForScaledNumberFieldMapping(final IndexFieldTypeOptionsStep<?, ?> step, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForScaledNumberFieldMapping$str(), step, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotReferenceExtractorsWhenExtractionDisabled$str() {
        return "HSEARCH700052: Extractors cannot be defined explicitly when extract = ContainerExtract.NO. Either leave 'extract' to its default value to define extractors explicitly or leave the 'extractor' list to its default, empty value to disable extraction.";
    }
    @Override
    public final SearchException cannotReferenceExtractorsWhenExtractionDisabled() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotReferenceExtractorsWhenExtractionDisabled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotResolveContainerExtractorName$str() {
        return "HSEARCH700053: Cannot resolve container extractor name '%1$s'. Check that this name matches a container extractor, either a builtin one whose name is a constant in '%2$s' or a custom one that was properly registered.";
    }
    @Override
    public final SearchException cannotResolveContainerExtractorName(final String extractorName, final Class<?> builtinExtractorConstantsClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotResolveContainerExtractorName$str(), extractorName, new org.hibernate.search.util.common.logging.impl.ClassFormatter(builtinExtractorConstantsClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotPurgeNonIndexedContainedType$str() {
        return "HSEARCH700055: Type '%1$s' is contained in an indexed type but is not itself indexed, thus entity with identifier '%2$s' cannot be purged. Use delete() and pass the entity instead of just the identifier.";
    }
    @Override
    public final SearchException cannotPurgeNonIndexedContainedType(final PojoRawTypeIdentifier<?> type, final Object providedId) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotPurgeNonIndexedContainedType$str(), type, providedId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotAccessPropertyMember$str() {
        return "HSEARCH700056: Could not access to the org.hibernate.annotations.common.reflection.java.JavaXMember#getMember method";
    }
    @Override
    public final SearchException cannotAccessPropertyMember(final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotAccessPropertyMember$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotAccessPropertyMethod$str() {
        return "HSEARCH700057: The underlying member of property '%1$s' is supposed to be a method";
    }
    @Override
    public final SearchException cannotAccessPropertyMethod(final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotAccessPropertyMethod$str(), propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingBridgeForBinder$str() {
        return "HSEARCH700058: The bind() method of binder '%1$s' is not implemented correctly: it did not call context.bridge().";
    }
    @Override
    public final SearchException missingBridgeForBinder(final Object binder) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBridgeForBinder$str(), binder));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingMarkerForBinder$str() {
        return "HSEARCH700059: The bind() method of binder '%1$s' is not implemented correctly: it did not call context.marker(...).";
    }
    @Override
    public final SearchException missingMarkerForBinder(final Object binder) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingMarkerForBinder$str(), binder));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String recursiveIndexingPlanProcess$str() {
        return "HSEARCH700060: Entity processing was triggered while already processing entities, which is not supported. Make sure you do not change entities within an entity getter or a custom bridge used for indexing, and avoid any event that could trigger entity processing. Hibernate ORM flushes, in particular, must be avoided in entity getters and bridges.";
    }
    @Override
    public final SearchException recursiveIndexingPlanProcess() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), recursiveIndexingPlanProcess$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexedEmbedded$str() {
        return "HSEARCH700061: Type '%1$s' cannot be indexed-embedded, because no index mapping (@GenericField, @FullTextField, ...) is defined for that type.";
    }
    @Override
    public final SearchException invalidIndexedEmbedded(final PojoTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexedEmbedded$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleEntityNames$str() {
        return "HSEARCH700064: Multiple entity names assigned to the same type: '%1$s', '%2$s'.";
    }
    @Override
    public final SearchException multipleEntityNames(final String entityName, final String otherEntityName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleEntityNames$str(), entityName, otherEntityName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldEncodingForStandardFieldMapping$str() {
        return "HSEARCH700065: This property's mapping expects a standard type for the index field, but the assigned value bridge or value binder declares a non-standard type. Make sure to use a compatible bridge or binder. Details: encountered type DSL step '%1$s', which does not extend the expected '%2$s' interface.";
    }
    @Override
    public final SearchException invalidFieldEncodingForStandardFieldMapping(final IndexFieldTypeOptionsStep<?, ?> step, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForStandardFieldMapping$str(), step, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldEncodingForNonStandardFieldMapping$str() {
        return "HSEARCH700066: This property's mapping expects a non-standard type for the index field, but the assigned value bridge or value binder declares a standard type. Switch to a standard field annotation such as @GenericField. Details: encountered type DSL step '%1$s', which does extend the '%2$s' interface.";
    }
    @Override
    public final SearchException invalidFieldEncodingForNonStandardFieldMapping(final IndexFieldTypeOptionsStep<?, ?> step, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForNonStandardFieldMapping$str(), step, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAnnotationTypeForAnnotationProcessor$str() {
        return "HSEARCH700067: Annotation processor '%1$s' expects annotations of incompatible type '%2$s'.";
    }
    @Override
    public final SearchException invalidAnnotationTypeForAnnotationProcessor(final Object annotationProcessor, final Class<?> processorAnnotationType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAnnotationTypeForAnnotationProcessor$str(), annotationProcessor, new org.hibernate.search.util.common.logging.impl.ClassFormatter(processorAnnotationType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingProcessorReferenceInMappingAnnotation$str() {
        return "HSEARCH700068: The processor reference in meta-annotation '%1$s' is empty.";
    }
    @Override
    public final SearchException missingProcessorReferenceInMappingAnnotation(final Class<? extends java.lang.annotation.Annotation> metaAnnotationType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingProcessorReferenceInMappingAnnotation$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(metaAnnotationType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSetBothIndexedEmbeddedNameAndPrefix$str() {
        return "HSEARCH700069: Cannot set both the name and prefix in @IndexedEmbedded. Name was '%1$s', prefix was '%2$s'.";
    }
    @Override
    public final SearchException cannotSetBothIndexedEmbeddedNameAndPrefix(final String relativeFieldName, final String prefix) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotSetBothIndexedEmbeddedNameAndPrefix$str(), relativeFieldName, prefix));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldNameDotNotAllowed$str() {
        return "HSEARCH700070: Index field name '%1$s' is invalid: field names cannot contain a dot ('.').";
    }
    @Override
    public final SearchException invalidFieldNameDotNotAllowed(final String relativeFieldName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldNameDotNotAllowed$str(), relativeFieldName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindAlternativeDiscriminator$str() {
        return "HSEARCH700071: Could not find any property marked with @Alternative(id = %1$s). There must be exactly one such property in order to map property '%2$s' to multi-alternative fields.";
    }
    @Override
    public final SearchException cannotFindAlternativeDiscriminator(final String alternativeId, final String fieldValueSourcePropertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindAlternativeDiscriminator$str(), alternativeId, fieldValueSourcePropertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingAlternativeDiscriminators$str() {
        return "HSEARCH700072: Found multiple properties marked with @Alternative(id = %1$s). There must be exactly one such property in order to map property '%2$s' to multi-alternative fields.";
    }
    @Override
    public final SearchException conflictingAlternativeDiscriminators(final String alternativeId, final String fieldValueSourcePropertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingAlternativeDiscriminators$str(), alternativeId, fieldValueSourcePropertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidInputTypeForRoutingBridge$str() {
        return "HSEARCH700073: Routing bridge '%1$s' cannot be applied to entity type '%2$s'.";
    }
    @Override
    public final SearchException invalidInputTypeForRoutingBridge(final Object routingBridge, final PojoTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidInputTypeForRoutingBridge$str(), routingBridge, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingRoutingBridgeAndRoutingKeyBinder$str() {
        return "HSEARCH700074: Routing bridge '%1$s' is already assigned to this entity; cannot apply routing key binder '%2$s'.";
    }
    @Override
    public final SearchException conflictingRoutingBridgeAndRoutingKeyBinder(final Object routingBridge, final Object binder) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingRoutingBridgeAndRoutingKeyBinder$str(), routingBridge, binder));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noCurrentRoute$str() {
        return "HSEARCH700075: Routing bridge '%1$s' did not define any current route. Exactly one current route must be defined, or you can call notIndexed() to explicitly indicate no route is necessary.";
    }
    @Override
    public final SearchException noCurrentRoute(final Object routingBridge) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noCurrentRoute$str(), routingBridge));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleCurrentRoutes$str() {
        return "HSEARCH700076: Routing bridge '%1$s' defined multiple current routes. At most one current route must be defined.";
    }
    @Override
    public final SearchException multipleCurrentRoutes(final Object routingBridge) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleCurrentRoutes$str(), routingBridge));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noPreviousRoute$str() {
        return "HSEARCH700077: Routing bridge '%1$s' did not define any previous route. At least one previous route must be defined, or you can call notIndexed() to explicitly indicate no route was necessary.";
    }
    @Override
    public final SearchException noPreviousRoute(final Object routingBridge) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noPreviousRoute$str(), routingBridge));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindReadableProperty$str() {
        return "HSEARCH700078: Unable to find a readable property '%2$s' on type '%1$s'.";
    }
    @Override
    public final SearchException cannotFindReadableProperty(final PojoRawTypeModel<?> typeModel, final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindReadableProperty$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH700079: Exception while retrieving property type model for '%1$s' on '%2$s'.";
    }
    @Override
    public final SearchException errorRetrievingPropertyTypeModel(final String propertyModelName, final PojoRawTypeModel<?> parentTypeModel, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingPropertyTypeModel$str(), propertyModelName, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(parentTypeModel)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
